/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.FilesCreationForm;
import org.osivia.services.edition.portlet.repository.AbstractDocumentEditionRepositoryImpl;
import org.osivia.services.edition.portlet.repository.command.ImportFilesCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.springframework.web.multipart.MultipartFile;

@Repository
public class FilesCreationRepositoryImpl
extends AbstractDocumentEditionRepositoryImpl<FilesCreationForm> {
    private final Set<String> acceptedDocumentTypes = Stream.of("File", "Picture", "Audio", "Video").collect(Collectors.toSet());
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public Class<FilesCreationForm> getParameterizedType() {
        return FilesCreationForm.class;
    }

    @Override
    public boolean matches(String documentType, boolean creation) {
        return creation && this.acceptedDocumentTypes.contains(documentType);
    }

    @Override
    public String getViewPath(PortalControllerContext portalControllerContext) {
        return "files";
    }

    @Override
    protected void customizeValidation(FilesCreationForm form, Errors errors) {
        String requiredPrimaryType;
        switch (form.getWindowProperties().getDocumentType()) {
            case "Audio": {
                requiredPrimaryType = "audio";
                break;
            }
            case "Picture": {
                requiredPrimaryType = "image";
                break;
            }
            case "Video": {
                requiredPrimaryType = "video";
                break;
            }
            default: {
                requiredPrimaryType = null;
            }
        }
        if (CollectionUtils.isEmpty(form.getTemporaryFiles())) {
            errors.rejectValue("upload", "NotEmpty");
        } else if (StringUtils.isNotEmpty((String)requiredPrimaryType)) {
            for (FilesCreationForm.TemporaryFile temporaryFile : form.getTemporaryFiles()) {
                MimeType mimeType = temporaryFile.getFileMimeType();
                if (mimeType != null && StringUtils.equals((String)requiredPrimaryType, (String)mimeType.getPrimaryType())) continue;
                errors.rejectValue("upload", "InvalidFileType", new Object[]{temporaryFile.getFileName()}, null);
            }
        }
    }

    @Override
    protected void customizeUpload(PortalControllerContext portalControllerContext, FilesCreationForm form) throws IOException {
        if (CollectionUtils.isNotEmpty(form.getUpload())) {
            List<FilesCreationForm.TemporaryFile> temporaryFiles = form.getTemporaryFiles();
            if (CollectionUtils.isEmpty(temporaryFiles)) {
                temporaryFiles = new ArrayList<FilesCreationForm.TemporaryFile>(form.getUpload().size());
                form.setTemporaryFiles(temporaryFiles);
            }
            for (MultipartFile upload : form.getUpload()) {
                MimeType mimeType;
                File file = File.createTempFile("document-creation-files-", ".tmp");
                file.deleteOnExit();
                upload.transferTo(file);
                try {
                    mimeType = new MimeType(upload.getContentType());
                }
                catch (MimeTypeParseException e) {
                    mimeType = null;
                }
                FilesCreationForm.TemporaryFile temporaryFile = (FilesCreationForm.TemporaryFile)this.applicationContext.getBean(FilesCreationForm.TemporaryFile.class);
                temporaryFile.setFile(file);
                temporaryFile.setFileName(upload.getOriginalFilename());
                temporaryFile.setFileMimeType(mimeType);
                temporaryFiles.add(temporaryFile);
            }
        }
    }

    @Override
    protected void customizeRestore(PortalControllerContext portalControllerContext, FilesCreationForm form) {
        if (CollectionUtils.isNotEmpty(form.getTemporaryFiles())) {
            PortletRequest request = portalControllerContext.getRequest();
            int index = NumberUtils.toInt((String)request.getParameter("restore"), (int)-1);
            if (index < 0) {
                for (FilesCreationForm.TemporaryFile temporaryFile : form.getTemporaryFiles()) {
                    FileUtils.deleteQuietly((File)temporaryFile.getFile());
                }
                form.getTemporaryFiles().clear();
            } else if (index < form.getTemporaryFiles().size()) {
                FilesCreationForm.TemporaryFile temporaryFile = form.getTemporaryFiles().get(index);
                FileUtils.deleteQuietly((File)temporaryFile.getFile());
                form.getTemporaryFiles().remove(index);
            }
        }
    }

    @Override
    protected void customizeProperties(PortalControllerContext portalControllerContext, FilesCreationForm form, PropertyMap properties, Map<String, List<Blob>> binaries) {
        if (CollectionUtils.isNotEmpty(form.getTemporaryFiles())) {
            ArrayList<FileBlob> blobs = new ArrayList<FileBlob>();
            for (FilesCreationForm.TemporaryFile temporaryFile : form.getTemporaryFiles()) {
                String name = Normalizer.normalize(temporaryFile.getFileName(), Normalizer.Form.NFC);
                String contentType = temporaryFile.getFileMimeType() == null ? null : temporaryFile.getFileMimeType().toString();
                FileBlob blob = new FileBlob(temporaryFile.getFile(), name, contentType);
                blobs.add(blob);
            }
            binaries.put("", blobs);
        }
    }

    @Override
    protected Document create(NuxeoController nuxeoController, String parentPath, String type, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException {
        List<Blob> blobs = binaries.get("");
        if (CollectionUtils.isEmpty(blobs)) {
            throw new PortletException("Empty files");
        }
        ImportFilesCommand command = (ImportFilesCommand)this.applicationContext.getBean(ImportFilesCommand.class);
        command.setParentPath(parentPath);
        command.setBinaries(blobs);
        Document document = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        if (blobs.size() > 1) {
            document = null;
        }
        return document;
    }
}

