/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.PortletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.Attachments;
import org.osivia.services.edition.portlet.model.ExistingFile;
import org.osivia.services.edition.portlet.model.UploadTemporaryFile;
import org.osivia.services.edition.portlet.repository.DocumentEditionAttachmentsRepository;
import org.osivia.services.edition.portlet.repository.DocumentEditionCommonRepositoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.springframework.web.multipart.MultipartFile;

@Repository
public class DocumentEditionAttachmentsRepositoryImpl
extends DocumentEditionCommonRepositoryImpl<Attachments>
implements DocumentEditionAttachmentsRepository {
    protected static final String ATTACHMENTS_PROPERTY = "files:files";
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public Attachments get(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        TreeMap<ExistingFile, Boolean> existingFiles;
        if (document == null) {
            existingFiles = null;
        } else {
            PropertyList attachmentsList = document.getProperties().getList(ATTACHMENTS_PROPERTY);
            if (attachmentsList == null || attachmentsList.isEmpty()) {
                existingFiles = null;
            } else {
                existingFiles = new TreeMap<ExistingFile, Boolean>(Comparator.comparingInt(ExistingFile::getIndex));
                for (int i = 0; i < attachmentsList.size(); ++i) {
                    MimeType mimeType;
                    PropertyMap attachmentMap = attachmentsList.getMap(i);
                    PropertyMap attachmentFileMap = attachmentMap.getMap("file");
                    String fileName = attachmentFileMap.getString("name");
                    try {
                        mimeType = new MimeType(attachmentFileMap.getString("mime-type"));
                    }
                    catch (MimeTypeParseException e) {
                        mimeType = null;
                    }
                    ExistingFile file = (ExistingFile)this.applicationContext.getBean(ExistingFile.class);
                    file.setIndex(i);
                    file.setFileName(fileName);
                    file.setMimeType(mimeType);
                    existingFiles.put(file, false);
                }
            }
        }
        Attachments attachments = (Attachments)this.applicationContext.getBean(Attachments.class);
        attachments.setExistingFiles(existingFiles);
        return attachments;
    }

    @Override
    public void uploadAttachments(PortalControllerContext portalControllerContext, Attachments attachments) throws PortletException, IOException {
        List<UploadTemporaryFile> temporaryFiles = attachments.getUploadTemporaryFiles();
        if (CollectionUtils.isEmpty(temporaryFiles)) {
            temporaryFiles = new ArrayList<UploadTemporaryFile>();
            attachments.setUploadTemporaryFiles(temporaryFiles);
        }
        for (MultipartFile multipartFile : attachments.getUpload()) {
            UploadTemporaryFile temporaryFile = this.createTemporaryFile(multipartFile);
            temporaryFiles.add(temporaryFile);
        }
    }

    @Override
    public void deleteAttachment(PortalControllerContext portalControllerContext, Attachments attachments, String value) throws PortletException, IOException {
        String[] split = StringUtils.split((String)value, (String)"-");
        if (ArrayUtils.getLength((Object)split) == 2) {
            List<UploadTemporaryFile> temporaryFiles;
            int index = NumberUtils.toInt((String)split[1], (int)-1);
            if (StringUtils.equals((String)"existing", (String)split[0])) {
                SortedMap<ExistingFile, Boolean> existingFiles = attachments.getExistingFiles();
                if (MapUtils.isNotEmpty(existingFiles)) {
                    existingFiles.entrySet().stream().filter(entry -> ((ExistingFile)entry.getKey()).getIndex() == index).forEach(entry -> entry.setValue(true));
                }
            } else if (StringUtils.equals((String)"temporary", (String)split[0]) && CollectionUtils.isNotEmpty(temporaryFiles = attachments.getUploadTemporaryFiles()) && index >= 0 && index < temporaryFiles.size()) {
                UploadTemporaryFile temporaryFile = temporaryFiles.get(index);
                if (temporaryFile.getFile() != null && !temporaryFile.getFile().delete()) {
                    temporaryFile.getFile().deleteOnExit();
                }
                temporaryFiles.remove(temporaryFile);
            }
        }
    }

    @Override
    public void restoreAttachment(PortalControllerContext portalControllerContext, Attachments attachments, String value) throws PortletException, IOException {
        int index = NumberUtils.toInt((String)value, (int)-1);
        SortedMap<ExistingFile, Boolean> existingFiles = attachments.getExistingFiles();
        if (MapUtils.isNotEmpty(existingFiles)) {
            existingFiles.entrySet().stream().filter(entry -> ((ExistingFile)entry.getKey()).getIndex() == index).forEach(entry -> entry.setValue(false));
        }
    }

    @Override
    public void validate(Attachments attachments, Errors errors) {
    }

    @Override
    public void customizeProperties(PortalControllerContext portalControllerContext, Attachments attachments, boolean creation, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException {
        List<UploadTemporaryFile> temporaryFiles;
        SortedMap<ExistingFile, Boolean> existingFiles = attachments.getExistingFiles();
        if (MapUtils.isNotEmpty(existingFiles)) {
            List indexes = existingFiles.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).map(ExistingFile::getIndex).sorted(Collections.reverseOrder()).collect(Collectors.toList());
            for (Integer index : indexes) {
                String xpath = "files:files/item[" + index + "]";
                binaries.put(xpath, null);
            }
        }
        if (CollectionUtils.isNotEmpty(temporaryFiles = attachments.getUploadTemporaryFiles())) {
            List blobs = temporaryFiles.stream().map(this::convert).collect(Collectors.toList());
            binaries.put(ATTACHMENTS_PROPERTY, blobs);
        }
    }

    protected Blob convert(UploadTemporaryFile temporaryFile) {
        String contentType = temporaryFile.getMimeType() == null ? null : temporaryFile.getMimeType().toString();
        return new FileBlob(temporaryFile.getFile(), temporaryFile.getFileName(), contentType);
    }
}

