/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.AbstractDocumentEditionForm;
import org.osivia.services.edition.portlet.model.NoteEditionForm;
import org.osivia.services.edition.portlet.repository.DocumentEditionRepositoryImpl;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

@Repository
public class NoteEditionRepositoryImpl
extends DocumentEditionRepositoryImpl<NoteEditionForm> {
    public static final String CONTENT_PROPERTY = "note:note";

    public Class<NoteEditionForm> getParameterizedType() {
        return NoteEditionForm.class;
    }

    public boolean matches(String documentType, boolean creation) {
        return "Note".equals(documentType);
    }

    protected void customizeForm(PortalControllerContext portalControllerContext, Document document, NoteEditionForm form) {
        form.setFullscreen(true);
        if (document != null) {
            String content = document.getString(CONTENT_PROPERTY);
            form.setContent(content);
        }
    }

    protected void customizeValidation(NoteEditionForm form, Errors errors) {
        super.customizeValidation((AbstractDocumentEditionForm)form, errors);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"content", (String)"NotEmpty");
    }

    public String getViewPath(PortalControllerContext portalControllerContext) {
        return "note";
    }

    public void customizeProperties(PortalControllerContext portalControllerContext, NoteEditionForm form, boolean creation, PropertyMap properties, Map<String, List<Blob>> binaries) {
        properties.set(CONTENT_PROPERTY, StringUtils.trimToNull((String)form.getContent()));
    }
}

