/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.link.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.FileDocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.core.web.IWebIdService;
import org.osivia.services.editor.link.portlet.model.EditorLinkForm;
import org.osivia.services.editor.link.portlet.model.UrlType;
import org.osivia.services.editor.link.portlet.repository.EditorLinkRepository;
import org.osivia.services.editor.link.portlet.repository.command.SearchDocumentsCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class EditorLinkRepositoryImpl
implements EditorLinkRepository {
    private static final String WEB_ID_PROPERTY = "ttc:webid";
    private static final String VIGNETTE_PROPERTY = "ttc:vignette";
    private static final String DESCRIPTION_PROPERTY = "dc:description";
    private static final String DOCUMENT_URL_PREFIX = "/nuxeo/web/";
    private static final String DOCUMENT_URL_REGEX = "/nuxeo/web/([a-zA-Z0-9-_/]+).*";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IWebIdService webIdService;
    @Autowired
    private INuxeoService nuxeoService;
    @Autowired
    private DocumentDAO documentDAO;
    private final Pattern documentUrlPattern = Pattern.compile("/nuxeo/web/([a-zA-Z0-9-_/]+).*");

    public String getDocumentUrl(PortalControllerContext portalControllerContext, String webId) throws PortletException {
        return DOCUMENT_URL_PREFIX + webId;
    }

    public DocumentDTO getDocumentDto(PortalControllerContext portalControllerContext, String webId) throws PortletException {
        Document document = this.getDocument(portalControllerContext, webId);
        return this.documentDAO.toDTO(document);
    }

    public PaginableDocuments searchDocuments(PortalControllerContext portalControllerContext, String basePath, String filter, int page) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(SearchDocumentsCommand.class, new Object[]{basePath, filter, page});
        return (PaginableDocuments)nuxeoController.executeNuxeoCommand(command);
    }

    public Map<String, String> getDocumentProperties(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        DocumentDTO dto = this.documentDAO.toDTO(document);
        PropertyMap vignettePropertyMap = document.getProperties().getMap(VIGNETTE_PROPERTY);
        String vignetteUrl = vignettePropertyMap == null || vignettePropertyMap.isEmpty() ? null : nuxeoController.createFileLink(document, VIGNETTE_PROPERTY);
        String icon = dto.getIcon();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", document.getString(WEB_ID_PROPERTY));
        properties.put("title", document.getTitle());
        properties.put("vignette", vignetteUrl);
        properties.put("icon", icon);
        properties.put("description", document.getString(DESCRIPTION_PROPERTY));
        return properties;
    }

    public EditorLinkForm createForm(PortalControllerContext portalControllerContext, String url, String text, String title, boolean onlyText) throws PortletException {
        UrlType urlType;
        Document document;
        EditorLinkForm form = (EditorLinkForm)this.applicationContext.getBean(EditorLinkForm.class);
        form.setUrl(url);
        form.setText(text);
        form.setTitle(title);
        form.setDisplayText(onlyText);
        if (StringUtils.startsWith((String)url, (String)DOCUMENT_URL_PREFIX)) {
            Matcher matcher = this.documentUrlPattern.matcher(url);
            if (matcher.matches()) {
                String webId = matcher.group(1);
                try {
                    document = this.getDocument(portalControllerContext, webId);
                }
                catch (NuxeoException e) {
                    document = null;
                }
            } else {
                document = null;
            }
        } else {
            document = null;
        }
        if (document == null) {
            urlType = UrlType.MANUAL;
            form.setManualUrl(url);
        } else {
            urlType = UrlType.DOCUMENT;
            form.setDocumentWebId(document.getString(WEB_ID_PROPERTY));
            DocumentDTO dto = this.documentDAO.toDTO(document);
            form.setDocument(dto);
        }
        form.setUrlType(urlType);
        return form;
    }

    private Document getDocument(PortalControllerContext portalControllerContext, String webId) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String path = this.webIdService.webIdToFetchPath(webId);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        return documentContext.getDocument();
    }

    public Collection<DocumentType> getDocumentTypes(PortalControllerContext portalControllerContext) throws PortletException {
        INuxeoCustomizer cmsCustomizer = this.nuxeoService.getCMSCustomizer();
        return cmsCustomizer.getDocumentTypes().values();
    }

    public Collection<FileDocumentType> getFileDocumentTypes(PortalControllerContext portalControllerContext) throws PortletException {
        INuxeoCustomizer cmsCustomizer = this.nuxeoService.getCMSCustomizer();
        return cmsCustomizer.getFileDocumentTypes();
    }
}

