/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.image.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.services.editor.common.repository.CommonRepositoryImpl;
import org.osivia.services.editor.image.portlet.model.AttachedImage;
import org.osivia.services.editor.image.portlet.model.SearchScope;
import org.osivia.services.editor.image.portlet.repository.EditorImageRepository;
import org.osivia.services.editor.image.portlet.repository.command.AddAttachedImageCommand;
import org.osivia.services.editor.image.portlet.repository.command.DeleteAttachedImageCommand;
import org.osivia.services.editor.image.portlet.repository.command.SearchImageDocumentsCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class EditorImageRepositoryImpl
extends CommonRepositoryImpl
implements EditorImageRepository {
    @Autowired
    private ApplicationContext applicationContext;

    public SortedSet<AttachedImage> getAttachedImages(PortalControllerContext portalControllerContext, String path) {
        TreeSet<AttachedImage> attachedImages;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Document document = this.getDocument(portalControllerContext, path);
        PropertyList list = document.getProperties().getList("ttc:images");
        if (list == null || list.isEmpty()) {
            attachedImages = null;
        } else {
            attachedImages = new TreeSet<AttachedImage>();
            for (int i = 0; i < list.size(); ++i) {
                PropertyMap map = list.getMap(i).getMap("file");
                String fileName = map.getString("name");
                String url = nuxeoController.createAttachedPictureLink(path, String.valueOf(i), fileName);
                AttachedImage attachedImage = (AttachedImage)this.applicationContext.getBean(AttachedImage.class);
                attachedImage.setIndex(i);
                attachedImage.setFileName(fileName);
                attachedImage.setUrl(url);
                attachedImages.add(attachedImage);
            }
        }
        return attachedImages;
    }

    public void addAttachedImage(PortalControllerContext portalControllerContext, String path, File temporaryFile, String fileName, String contentType) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(AddAttachedImageCommand.class, new Object[]{path, temporaryFile, fileName, contentType});
        nuxeoController.executeNuxeoCommand(command);
    }

    public String getAttachedImageUrl(PortalControllerContext portalControllerContext, AttachedImage attachedImage) {
        return "/nuxeo/nxfile/default/attachedImages/ttc:images/" + attachedImage.getIndex() + "/file/" + attachedImage.getFileName();
    }

    public void deleteAttachedImage(PortalControllerContext portalControllerContext, String path, int index) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(DeleteAttachedImageCommand.class, new Object[]{path, index});
        nuxeoController.executeNuxeoCommand(command);
    }

    public List<Document> search(PortalControllerContext portalControllerContext, String basePath, String filter, SearchScope scope) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(SearchImageDocumentsCommand.class, new Object[]{basePath, filter, scope});
        Documents result = (Documents)nuxeoController.executeNuxeoCommand(command);
        return result.list();
    }

    public String getImageDocumentUrl(PortalControllerContext portalControllerContext, String path) {
        Document document = this.getDocument(portalControllerContext, path);
        String webId = document.getString("ttc:webid");
        return "/nuxeo/web/" + webId + "?content=Original";
    }

    public CMSBinaryContent getImageDocumentPreviewBinaryContent(PortalControllerContext portalControllerContext, String webId, String content) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String fetchPath = "webId:" + webId;
        return nuxeoController.fetchPicture(fetchPath, content);
    }

    public CMSBinaryContent getAttachedImagePreviewBinaryContent(PortalControllerContext portalControllerContext, int index) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String path = nuxeoController.getContentPath();
        return nuxeoController.fetchAttachedPicture(path, String.valueOf(index));
    }
}

