/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.image.portlet.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.services.editor.common.repository.CommonRepository;
import org.osivia.services.editor.common.service.CommonServiceImpl;
import org.osivia.services.editor.image.portlet.model.AttachedImage;
import org.osivia.services.editor.image.portlet.model.EditorImageForm;
import org.osivia.services.editor.image.portlet.model.EditorImageSourceAttachedForm;
import org.osivia.services.editor.image.portlet.model.ImageSourceType;
import org.osivia.services.editor.image.portlet.model.TemporaryAttachedImage;
import org.osivia.services.editor.image.portlet.repository.EditorImageRepository;
import org.osivia.services.editor.image.portlet.service.EditorImageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class EditorImageServiceImpl
extends CommonServiceImpl
implements EditorImageService {
    private static final String ATTACHED_IMAGE_URL_REGEX = "/nuxeo/nxfile/default/attachedImages/(?<property>[^/]+)/(?<index>[0-9]+)/file.*";
    private final Pattern attachedImageUrlPattern = Pattern.compile("/nuxeo/nxfile/default/attachedImages/(?<property>[^/]+)/(?<index>[0-9]+)/file.*");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private EditorImageRepository repository;

    protected CommonRepository getRepository() {
        return this.repository;
    }

    public EditorImageForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        EditorImageForm form = (EditorImageForm)this.applicationContext.getBean(EditorImageForm.class);
        if (!form.isLoaded()) {
            ArrayList<ImageSourceType> availableSourceTypes;
            boolean attachments;
            PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
            boolean creation = BooleanUtils.toBoolean((String)window.getProperty("osivia.editor.creation"));
            form.setCreation(creation);
            String url = window.getProperty("osivia.editor.src");
            form.setUrl(url);
            String alt = window.getProperty("osivia.editor.alt");
            form.setAlt(alt);
            Integer height = NumberUtils.toInt((String)window.getProperty("osivia.editor.height"));
            if (height < 1) {
                height = null;
            }
            form.setHeight(height);
            Integer width = NumberUtils.toInt((String)window.getProperty("osivia.editor.width"));
            if (width < 1) {
                width = null;
            }
            form.setWidth(width);
            if (creation) {
                attachments = false;
            } else {
                Document document = this.repository.getDocument(portalControllerContext, window.getProperty("osivia.editor.path"));
                boolean bl = attachments = document.getProperties().getList("ttc:images") != null;
            }
            if (attachments) {
                availableSourceTypes = new ArrayList<ImageSourceType>();
                availableSourceTypes.add(ImageSourceType.ATTACHED);
                availableSourceTypes.add(ImageSourceType.DOCUMENT);
            } else {
                availableSourceTypes = null;
            }
            form.setAvailableSourceTypes(availableSourceTypes);
            form.setLoaded(true);
        }
        return form;
    }

    public void save(PortalControllerContext portalControllerContext, EditorImageForm form) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String path = window.getProperty("osivia.editor.path");
        if (StringUtils.equals((String)form.getTemporaryUrl(), (String)form.getUrl())) {
            TemporaryAttachedImage temporaryAttachedImage = form.getTemporaryAttachedImage();
            if (temporaryAttachedImage != null && temporaryAttachedImage.getFile() != null) {
                this.repository.addAttachedImage(portalControllerContext, path, temporaryAttachedImage.getFile(), temporaryAttachedImage.getFileName(), temporaryAttachedImage.getContentType());
                this.deleteTemporaryFile(temporaryAttachedImage);
            } else if (StringUtils.isNotEmpty((String)form.getTemporaryImagePath())) {
                this.repository.copyAttachedImage(portalControllerContext, form.getTemporaryImagePath(), path);
            }
            form.setTemporaryAttachedImage(null);
            form.setTemporaryImagePath(null);
        }
        form.setDone(true);
    }

    public EditorImageSourceAttachedForm getAttachedForm(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String path = window.getProperty("osivia.editor.path");
        EditorImageSourceAttachedForm attachedForm = (EditorImageSourceAttachedForm)this.applicationContext.getBean(EditorImageSourceAttachedForm.class);
        attachedForm.setMaxUploadSize(0x6400000L);
        SortedSet attachedImages = this.repository.getAttachedImages(portalControllerContext, path);
        attachedForm.setAttachedImages(attachedImages);
        return attachedForm;
    }

    public void addAttachedImage(PortalControllerContext portalControllerContext, EditorImageSourceAttachedForm attachedForm) throws PortletException, IOException {
        File temporaryFile = File.createTempFile("attached-image-", ".tmp");
        attachedForm.getUpload().transferTo(temporaryFile);
        String fileName = attachedForm.getUpload().getOriginalFilename();
        String contentType = attachedForm.getUpload().getContentType();
        EditorImageForm form = this.getForm(portalControllerContext);
        this.deleteTemporaryFile(form.getTemporaryAttachedImage());
        TemporaryAttachedImage temporaryAttachedImage = (TemporaryAttachedImage)this.applicationContext.getBean(TemporaryAttachedImage.class);
        temporaryAttachedImage.setFile(temporaryFile);
        temporaryAttachedImage.setFileName(fileName);
        temporaryAttachedImage.setContentType(contentType);
        form.setTemporaryAttachedImage(temporaryAttachedImage);
        int index = CollectionUtils.isEmpty((Collection)attachedForm.getAttachedImages()) ? 0 : attachedForm.getAttachedImages().size();
        String url = this.repository.getAttachedImageUrl(portalControllerContext, index, fileName);
        form.setUrl(url);
        form.setTemporaryUrl(url);
    }

    public void selectAttachedImage(PortalControllerContext portalControllerContext, EditorImageSourceAttachedForm attachedForm, int index) throws PortletException, IOException {
        EditorImageForm form = this.getForm(portalControllerContext);
        AttachedImage attachedImage = this.getAttachedImage(attachedForm.getAttachedImages(), index);
        String url = attachedImage == null ? null : this.repository.getAttachedImageUrl(portalControllerContext, index, attachedImage.getFileName());
        form.setUrl(url);
        form.setTemporaryUrl(url);
        TemporaryAttachedImage temporaryAttachedImage = form.getTemporaryAttachedImage();
        if (temporaryAttachedImage != null) {
            if (temporaryAttachedImage.getFile() != null && !temporaryAttachedImage.getFile().delete()) {
                temporaryAttachedImage.getFile().deleteOnExit();
            }
            form.setTemporaryAttachedImage(null);
        }
    }

    public void deleteAttachedImage(PortalControllerContext portalControllerContext, EditorImageSourceAttachedForm attachedForm, int index) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String path = window.getProperty("osivia.editor.path");
        SortedSet attachedImages = attachedForm.getAttachedImages();
        AttachedImage attachedImage = this.getAttachedImage(attachedImages, index);
        if (attachedImage != null) {
            this.repository.deleteAttachedImage(portalControllerContext, path, index);
            attachedImages.remove(attachedImage);
        }
    }

    private AttachedImage getAttachedImage(SortedSet<AttachedImage> attachedImages, int index) {
        AttachedImage result = null;
        if (CollectionUtils.isNotEmpty(attachedImages)) {
            Iterator iterator = attachedImages.iterator();
            while (result == null && iterator.hasNext()) {
                AttachedImage item = (AttachedImage)iterator.next();
                if (index != item.getIndex()) continue;
                result = item;
            }
        }
        return result;
    }

    public void selectDocument(PortalControllerContext portalControllerContext, String path) throws PortletException, IOException {
        Document source = this.repository.getDocument(portalControllerContext, path);
        EditorImageSourceAttachedForm attachedForm = this.getAttachedForm(portalControllerContext);
        int index = CollectionUtils.isEmpty((Collection)attachedForm.getAttachedImages()) ? 0 : attachedForm.getAttachedImages().size();
        EditorImageForm form = this.getForm(portalControllerContext);
        this.deleteTemporaryFile(form.getTemporaryAttachedImage());
        form.setTemporaryAttachedImage(null);
        form.setTemporaryImagePath(path);
        String url = this.repository.getAttachedImageUrl(portalControllerContext, index, source.getTitle());
        form.setUrl(url);
        form.setTemporaryUrl(url);
    }

    private void deleteTemporaryFile(TemporaryAttachedImage temporaryAttachedImage) {
        if (temporaryAttachedImage != null && temporaryAttachedImage.getFile() != null && !temporaryAttachedImage.getFile().delete()) {
            temporaryAttachedImage.getFile().deleteOnExit();
        }
    }

    public void serveImagePreview(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        CMSBinaryContent binaryContent;
        ResourceRequest request = (ResourceRequest)portalControllerContext.getRequest();
        ResourceResponse response = (ResourceResponse)portalControllerContext.getResponse();
        String source = request.getParameter("src");
        Matcher attachedImageUrlMatcher = this.attachedImageUrlPattern.matcher(source);
        if (StringUtils.startsWith((String)source, (String)"/nuxeo/web/")) {
            String webId = StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)source, (String)"?"), (String)"/");
            Object[] parameters = StringUtils.split((String)StringUtils.substringAfter((String)source, (String)"?"), (String)"&");
            String content = "Original";
            if (ArrayUtils.isNotEmpty((Object[])parameters)) {
                for (Object parameter : parameters) {
                    String[] split = StringUtils.split((String)parameter, (String)"=");
                    if (ArrayUtils.getLength((Object)split) != 2 || !StringUtils.equals((String)"content", (String)split[0])) continue;
                    content = split[1];
                }
            }
            binaryContent = this.repository.getImageDocumentPreviewBinaryContent(portalControllerContext, webId, content);
        } else if (attachedImageUrlMatcher.matches()) {
            int index = NumberUtils.toInt((String)attachedImageUrlMatcher.group("index"));
            binaryContent = this.repository.getAttachedImagePreviewBinaryContent(portalControllerContext, index);
        } else {
            throw new FileNotFoundException("Unknown source: " + source);
        }
        response.setContentType(binaryContent.getMimeType());
        response.setContentLength(binaryContent.getFileSize().intValue());
        response.getCacheControl().setExpirationTime(0);
        FileInputStream inputStream = new FileInputStream(binaryContent.getFile());
        OutputStream outputStream = response.getPortletOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }
}

