/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.link.portlet.controller;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.editor.link.portlet.model.EditorLinkForm;
import org.osivia.services.editor.link.portlet.model.validator.EditorLinkFormValidator;
import org.osivia.services.editor.link.portlet.service.EditorLinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class EditorLinkController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private EditorLinkService service;
    @Autowired
    private EditorLinkFormValidator validator;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ActionMapping(name="submit", params={"source-document"})
    public void sourceDocumentRedirection(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") EditorLinkForm form) {
        response.setRenderParameter("view", "document");
    }

    @ActionMapping(name="submit", params={"save"})
    public void submit(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="form") EditorLinkForm form, BindingResult bindingResult) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!bindingResult.hasErrors()) {
            this.service.save(portalControllerContext, form);
        }
    }

    @ActionMapping(value="unlink")
    public void unlink(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") EditorLinkForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.unlink(portalControllerContext, form);
    }

    @ModelAttribute(value="form")
    public EditorLinkForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.validator});
        binder.setDisallowedFields(new String[]{"done", "loaded"});
    }
}

