/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.common.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.editor.common.model.SearchScope;
import org.osivia.services.editor.common.repository.CommonRepository;
import org.osivia.services.editor.common.repository.command.SearchSourceDocumentCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class CommonRepositoryImpl
implements CommonRepository {
    @Autowired
    private ApplicationContext applicationContext;

    public Document getDocument(PortalControllerContext portalControllerContext, String path) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        documentContext.reload();
        return documentContext.getDocument();
    }

    public PaginableDocuments searchDocuments(PortalControllerContext portalControllerContext, String basePath, String filter, SearchScope scope) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        SearchSourceDocumentCommand command = (SearchSourceDocumentCommand)this.applicationContext.getBean(SearchSourceDocumentCommand.class);
        command.setBasePath(basePath);
        command.setFilter(filter);
        command.setScope(scope);
        return (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
    }
}

