/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.link.portlet.service;

import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.editor.common.repository.CommonRepository;
import org.osivia.services.editor.common.service.CommonServiceImpl;
import org.osivia.services.editor.link.portlet.model.EditorLinkForm;
import org.osivia.services.editor.link.portlet.repository.EditorLinkRepository;
import org.osivia.services.editor.link.portlet.service.EditorLinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class EditorLinkServiceImpl
extends CommonServiceImpl
implements EditorLinkService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private EditorLinkRepository repository;

    protected CommonRepository getRepository() {
        return this.repository;
    }

    public void save(PortalControllerContext portalControllerContext, EditorLinkForm form) throws PortletException {
        if (StringUtils.isBlank((String)form.getText())) {
            Document document = this.repository.getDocumentFromUrl(portalControllerContext, form.getUrl());
            String text = document == null || StringUtils.isEmpty((String)document.getTitle()) ? form.getUrl() : document.getTitle();
            form.setText(text);
        }
        form.setDone(true);
    }

    public void unlink(PortalControllerContext portalControllerContext, EditorLinkForm form) {
        form.setUrl("");
        form.setDone(true);
    }

    public EditorLinkForm getForm(PortalControllerContext portalControllerContext) {
        EditorLinkForm form = (EditorLinkForm)this.applicationContext.getBean(EditorLinkForm.class);
        if (!form.isLoaded()) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
            String url = window.getProperty("osivia.editor.url");
            form.setUrl(url);
            String text = window.getProperty("osivia.editor.text");
            form.setText(text);
            String title = window.getProperty("osivia.editor.title");
            form.setTitle(title);
            boolean onlyText = BooleanUtils.toBoolean((String)window.getProperty("osivia.editor.onlyText"));
            form.setDisplayText(onlyText);
            form.setLoaded(true);
        }
        return form;
    }

    public void selectDocument(PortalControllerContext portalControllerContext, String path) throws PortletException {
        Document source = this.repository.getDocument(portalControllerContext, path);
        String webId = source.getString("ttc:webid");
        String url = this.repository.getDocumentUrl(portalControllerContext, webId);
        EditorLinkForm form = this.getForm(portalControllerContext);
        form.setUrl(url);
    }
}

