/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.plugin.configuration;

import javax.portlet.PortletConfig;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.portlet.PortletAppUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.portlet.context.PortletConfigAware;

@Configuration
@ComponentScan(basePackages={"org.osivia.services.editor.plugin", "org.osivia.services.editor.image.portlet"})
public class EditorPluginConfiguration
implements PortletConfigAware {
    @Autowired
    private ApplicationContext applicationContext;

    public void setPortletConfig(PortletConfig portletConfig) {
        PortletAppUtils.registerApplication((PortletConfig)portletConfig, (Object)this.applicationContext);
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"plugin"});
        return messageSource;
    }

    @Bean
    public IBundleFactory getBundleFactory() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        return internationalizationService.getBundleFactory(this.getClass().getClassLoader(), this.applicationContext);
    }
}

