/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.link.portlet.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.math.NumberUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.editor.link.portlet.model.EditorLinkForm;
import org.osivia.services.editor.link.portlet.model.UrlType;
import org.osivia.services.editor.link.portlet.model.validator.EditorLinkFormValidator;
import org.osivia.services.editor.link.portlet.service.EditorLinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class EditorLinkController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private EditorLinkService service;
    @Autowired
    private EditorLinkFormValidator validator;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ActionMapping(value="submit")
    public void submit(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="form") EditorLinkForm form, BindingResult bindingResult) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!bindingResult.hasErrors()) {
            this.service.save(portalControllerContext, form);
        }
    }

    @ActionMapping(value="unlink")
    public void unlink(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") EditorLinkForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.unlink(portalControllerContext, form);
    }

    @ResourceMapping(value="search")
    public void search(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="page", required=false) String page) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        JSONObject results = this.service.searchDocuments(portalControllerContext, filter, NumberUtils.toInt((String)page, (int)1));
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(results.toString());
        printWriter.close();
    }

    @ModelAttribute(value="form")
    public EditorLinkForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.validator});
        binder.setDisallowedFields(new String[]{"done", "url", "onlyText"});
    }

    @ModelAttribute(value="urlTypes")
    public List<UrlType> getUrlTypes(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getUrlTypes(portalControllerContext);
    }
}

