/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.faq.portail;

import fr.toutatice.faq.portail.FaqFetchChildrenCommand;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.path.PortletPathItem;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class FaqPortlet
extends CMSPortlet {
    private static final String VIEW_JSP = "/WEB-INF/jsp/view.jsp";
    private static final String ERROR_JSP = "/WEB-INF/jsp/error.jsp";
    private static final String ADMIN_JSP = "/WEB-INF/jsp/admin.jsp";
    private DocumentDAO documentDao;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.documentDao = DocumentDAO.getInstance();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        String action = request.getParameter("javax.portlet.action");
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                window.setProperty("osivia.cms.uri", StringUtils.trimToNull((String)request.getParameter("path")));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        request.setAttribute("path", (Object)window.getProperty("osivia.cms.uri"));
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(ADMIN_JSP).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRequestDispatcher dispatcher;
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String errorMessageKey = null;
        try {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String path = request.getParameter("curItemPath");
            if (path == null) {
                path = window.getProperty("osivia.cms.uri");
            }
            NuxeoDocumentContext documentContext = null;
            documentContext = path != null ? nuxeoController.getDocumentContext(path) : nuxeoController.getCurrentDocumentContext();
            if ("1".equals(window.getProperty("osivia.cms.contextualization"))) {
                request.setAttribute("contextualization", (Object)"1");
            }
            if (documentContext != null) {
                Document document = documentContext.getDocument();
                String type = document.getType();
                if ("Question".equals(type)) {
                    Document question = document;
                    nuxeoController.setCurrentDoc(question);
                    response.setTitle(question.getTitle());
                    nuxeoController.insertContentMenuBarItems();
                    String faqPath = NuxeoController.getParentPath((String)question.getPath());
                    NuxeoDocumentContext faqContext = nuxeoController.getDocumentContext(faqPath);
                    ArrayList portletPath = new ArrayList();
                    this.addPathItem(portletPath, question);
                    this.addPathItem(portletPath, faqContext.getDocument());
                    request.setAttribute("osivia.portletPath", portletPath);
                    DocumentDTO questionDto = this.documentDao.toDTO(portalControllerContext, question);
                    request.setAttribute("question", (Object)questionDto);
                } else if ("FaqFolder".equals(type)) {
                    NuxeoDocumentContext faqContext = documentContext;
                    Document faq = document;
                    String faqPath = faq.getPath();
                    String faqLiveId = faqContext.getPublicationInfos().getLiveId();
                    NuxeoQueryFilterContext queryContext = nuxeoController.getQueryFilterContextForPath(faqPath);
                    FaqFetchChildrenCommand command = new FaqFetchChildrenCommand(queryContext, faqLiveId);
                    Documents questions = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                    nuxeoController.setCurrentDoc(faq);
                    ArrayList portletPath = new ArrayList();
                    this.addPathItem(portletPath, faq);
                    request.setAttribute("osivia.portletPath", portletPath);
                    response.setTitle(faq.getTitle());
                    nuxeoController.insertContentMenuBarItems();
                    DocumentDTO faqDto = this.documentDao.toDTO(portalControllerContext, faq);
                    request.setAttribute("faq", (Object)faqDto);
                    ArrayList<DocumentDTO> questionsDto = new ArrayList<DocumentDTO>(questions.size());
                    for (Document question : questions.list()) {
                        DocumentDTO questionDto = this.documentDao.toDTO(portalControllerContext, question);
                        questionDto.getProperties().put("url", nuxeoController.getLink(question).getUrl());
                        questionsDto.add(questionDto);
                    }
                    request.setAttribute("questions", questionsDto);
                } else {
                    errorMessageKey = "ERROR_NOT_FAQ_TYPE";
                }
            } else {
                errorMessageKey = "ERROR_PATH_UNDEFINED";
            }
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        response.setContentType("text/html");
        if (errorMessageKey == null) {
            dispatcher = this.getPortletContext().getRequestDispatcher(VIEW_JSP);
        } else {
            request.setAttribute("errorKey", errorMessageKey);
            dispatcher = this.getPortletContext().getRequestDispatcher(ERROR_JSP);
        }
        dispatcher.include(request, response);
    }

    private void addPathItem(List<PortletPathItem> portletPath, Document document) {
        HashMap<String, String> renderParams = new HashMap<String, String>();
        renderParams.put("curItemPath", document.getPath());
        PortletPathItem pathItem = new PortletPathItem(renderParams, document.getTitle());
        portletPath.add(0, pathItem);
    }
}

