/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.ThreadPostDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.services.forum.portlets.model.Thread;
import org.osivia.services.forum.portlets.model.ThreadObject;
import org.osivia.services.forum.portlets.model.ThreadPost;
import org.osivia.services.forum.portlets.model.ThreadPostReplyForm;
import org.osivia.services.forum.portlets.service.IForumService;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ForumServiceImpl
implements IForumService {
    private static final String DOCUMENT_REQUEST_ATTRIBUTE = "osivia.forum.document";
    private final IPortalUrlFactory portalURLFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IDirectoryServiceLocator directoryServiceLocator = (IDirectoryServiceLocator)Locator.findMBean(IDirectoryServiceLocator.class, (String)"osivia:service=DirectoryServiceLocator");

    public Document getDocument(NuxeoController nuxeoController) throws PortletException {
        try {
            Document document = (Document)nuxeoController.getRequest().getAttribute(DOCUMENT_REQUEST_ATTRIBUTE);
            if (document == null) {
                PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
                String pathProperty = window.getProperty("osivia.cms.uri");
                document = nuxeoController.fetchDocument(pathProperty);
                nuxeoController.getRequest().setAttribute(DOCUMENT_REQUEST_ATTRIBUTE, (Object)document);
            }
            return document;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public Thread getThread(NuxeoController nuxeoController) throws PortletException {
        Document document = this.getDocument(nuxeoController);
        return this.toViewObject(nuxeoController, document);
    }

    public List<ThreadPost> getThreadPosts(NuxeoController nuxeoController) throws PortletException {
        try {
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            Document document = this.getDocument(nuxeoController);
            INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
            List postsDTO = commentsService.getForumThreadPosts(cmsContext, document);
            ArrayList<ThreadPost> posts = new ArrayList<ThreadPost>(postsDTO.size());
            for (ThreadPostDTO postDTO : postsDTO) {
                ThreadPost post = this.toViewObject(nuxeoController, postDTO);
                posts.add(post);
            }
            return posts;
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void addThreadPost(NuxeoController nuxeoController, List<ThreadPost> posts, ThreadPostReplyForm replyForm, String parentId) throws PortletException {
        try {
            ThreadPostDTO post = this.toBusinessObject(replyForm);
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            Document document = this.getDocument(nuxeoController);
            INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
            commentsService.addDocumentComment(cmsContext, document, (CommentDTO)post, parentId);
            posts.clear();
            posts.addAll(this.getThreadPosts(nuxeoController));
            replyForm.setContent(null);
            replyForm.setAttachment(null);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void deleteThreadPost(NuxeoController nuxeoController, List<ThreadPost> posts, String id) throws PortletException {
        try {
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            Document document = this.getDocument(nuxeoController);
            INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
            commentsService.deleteDocumentComment(cmsContext, document, id);
            this.deleteThreadPostFromModel(posts, id);
            posts.clear();
            posts.addAll(this.getThreadPosts(nuxeoController));
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private boolean deleteThreadPostFromModel(List<ThreadPost> posts, String id) {
        boolean deleted = false;
        for (ThreadPost post : posts) {
            if (id.equals(post.getId())) {
                deleted = posts.remove(post);
                break;
            }
            if (post.getChildren() == null || !(deleted = this.deleteThreadPostFromModel(post.getChildren(), id))) continue;
            break;
        }
        return deleted;
    }

    private Thread toViewObject(NuxeoController nuxeoController, Document document) throws PortletException {
        try {
            IDirectoryService directoryService;
            Thread vo = new Thread();
            vo.setAuthor(document.getString("dc:creator"));
            vo.setMessage(document.getString("ttcth:message"));
            Date date = document.getDate("dc:created");
            vo.setDate(date);
            boolean isCommentable = this.isThreadCommentable(nuxeoController, document);
            vo.setCommentable(isCommentable);
            String attachmentName = document.getString("file:filename");
            if (attachmentName != null) {
                vo.setAttachmentName(attachmentName);
                String attachmentURL = nuxeoController.createFileLink(document.getPath(), "file:content", attachmentName);
                vo.setAttachmentURL(attachmentURL);
            }
            if ((directoryService = this.directoryServiceLocator.getDirectoryService()) != null) {
                DirectoryPerson person = directoryService.getPerson(vo.getAuthor());
                vo.setPerson(person);
                if (person != null) {
                    String profileURL = this.getUserProfilePageURL(nuxeoController, vo.getAuthor(), person.getDisplayName());
                    vo.setProfileURL(profileURL);
                }
            }
            return vo;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private ThreadPost toViewObject(NuxeoController nuxeoController, ThreadPostDTO dto) throws PortletException {
        try {
            ThreadPost vo = new ThreadPost();
            BeanUtils.copyProperties((Object)vo, (Object)dto);
            vo.setMessage(dto.getContent());
            vo.setDate(dto.getCreationDate());
            if (dto.getFilename() != null) {
                vo.setAttachmentName(dto.getFilename());
                String attachmentURL = nuxeoController.createFileLink(dto.getPath(), "post:fileContent", dto.getFilename());
                vo.setAttachmentURL(attachmentURL);
            }
            this.addDirectoryPerson(nuxeoController, (ThreadObject)vo);
            for (CommentDTO child : dto.getChildren()) {
                if (!(child instanceof ThreadPostDTO)) continue;
                ThreadPostDTO childDTO = (ThreadPostDTO)child;
                ThreadPost childVO = this.toViewObject(nuxeoController, childDTO);
                vo.getChildren().add(childVO);
            }
            return vo;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void addDirectoryPerson(NuxeoController nuxeoController, ThreadObject vo) {
        IDirectoryService directoryService = this.directoryServiceLocator.getDirectoryService();
        if (directoryService != null) {
            DirectoryPerson person = directoryService.getPerson(vo.getAuthor());
            vo.setPerson(person);
            if (person != null) {
                String profileURL = this.getUserProfilePageURL(nuxeoController, vo.getAuthor(), person.getDisplayName());
                vo.setProfileURL(profileURL);
            }
        }
    }

    private ThreadPostDTO toBusinessObject(ThreadPostReplyForm replyForm) throws PortletException {
        try {
            ThreadPostDTO post = new ThreadPostDTO();
            BeanUtils.copyProperties((Object)post, (Object)replyForm);
            MultipartFile attachmentMultipart = replyForm.getAttachment();
            if (attachmentMultipart != null && attachmentMultipart.getSize() > 0L) {
                File attachment = File.createTempFile("attachment", null);
                attachment.deleteOnExit();
                attachmentMultipart.transferTo(attachment);
                post.setAttachment(attachment);
                post.setFilename(attachmentMultipart.getOriginalFilename());
            } else {
                post.setAttachment(null);
            }
            return post;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private boolean isThreadCommentable(NuxeoController nuxeoController, Document document) throws CMSException {
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSPublicationInfos publicationInfos = cmsService.getPublicationInfos(nuxeoController.getCMSCtx(), document.getPath());
        return publicationInfos.isCommentableByUser();
    }

    private String getUserProfilePageURL(NuxeoController nuxeoController, String name, String displayName) {
        String url;
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.hideTitle", "1");
        properties.put("osivia.ajaxLink", "1");
        properties.put("theme.dyna.partial_refresh_enabled", "true");
        properties.put("uidFichePersonne", name);
        HashMap parameters = new HashMap(0);
        try {
            url = this.portalURLFactory.getStartPortletInNewPage(portalControllerContext, "myprofile", displayName, "toutatice-identite-fichepersonne-portailPortletInstance", properties, parameters);
        }
        catch (PortalException e) {
            url = null;
        }
        return url;
    }
}

