/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.portlets.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.services.forum.portlets.model.Thread;
import org.osivia.services.forum.portlets.model.ThreadPost;
import org.osivia.services.forum.portlets.model.ThreadPostReplyForm;
import org.osivia.services.forum.portlets.service.IForumService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller(value="forumController")
@RequestMapping(value={"VIEW"})
public class ForumPortletController
extends CMSPortlet
implements PortletContextAware,
PortletConfigAware {
    private static final String VIEW_PATH = "view";
    @Autowired
    private IForumService forumService;
    private PortletContext portletContext;
    private PortletConfig portletConfig;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        Document document = this.forumService.getDocument(nuxeoController);
        response.setTitle(document.getTitle());
        nuxeoController.setCurrentDoc(document);
        nuxeoController.insertContentMenuBarItems();
        return VIEW_PATH;
    }

    @ActionMapping(value="add")
    public void addCommentAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="posts") List<ThreadPost> posts, @ModelAttribute(value="replyForm") ThreadPostReplyForm replyForm, @RequestParam(value="parentId", required=false) String parentId) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.forumService.addThreadPost(nuxeoController, posts, replyForm, parentId);
    }

    @ActionMapping(value="delete")
    public void deleteCommentAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="posts") List<ThreadPost> posts, @RequestParam(value="id", required=true) String id) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.forumService.deleteThreadPost(nuxeoController, posts, id);
    }

    @ModelAttribute(value="thread")
    public Thread getThread(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        return this.forumService.getThread(nuxeoController);
    }

    @ModelAttribute(value="posts")
    public List<ThreadPost> getPosts(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        return this.forumService.getThreadPosts(nuxeoController);
    }

    @ModelAttribute(value="replyForm")
    public ThreadPostReplyForm getReplyForm(PortletRequest request, PortletResponse response) throws PortletException {
        return new ThreadPostReplyForm();
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}

