/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.plugin;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.Plugin;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.services.forum.plugin.ForumPlayer;

@Plugin(value="forum.plugin")
public class ForumPlugin
extends AbstractPluginPortlet {
    public static final String FORUM_LIST_TEMPLATE = "forum";
    private static final String PLUGIN_NAME = "forum.plugin";
    private static final String SCHEMAS = "dublincore, common, toutatice, file, thread_toutatice";
    private final IBundleFactory bundleFactory;

    public ForumPlugin() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    protected void customizeCMSProperties(String customizationID, CustomizationContext context) {
        this.customizeDocumentTypes(context);
        this.customizePlayers(context);
        this.customizeListTemplates(context);
        this.customizeTaskbarItems(context);
    }

    private void customizeDocumentTypes(CustomizationContext context) {
        Map types = this.getDocTypes(context);
        DocumentType thread = new DocumentType("Thread", false, false, false, false, true, true, new ArrayList(0), null, "glyphicons glyphicons-chat", false, false);
        types.put(thread.getName(), thread);
        DocumentType forum = new DocumentType("Forum", true, true, false, false, true, true, Arrays.asList(thread.getName()), null, "glyphicons glyphicons-conversation");
        types.put(forum.getName(), forum);
    }

    private void customizePlayers(CustomizationContext context) {
        List players = this.getPlayers(context);
        ForumPlayer forum = new ForumPlayer(this.getPortletContext());
        players.add(forum);
    }

    private void customizeListTemplates(CustomizationContext context) {
        Bundle bundle = this.bundleFactory.getBundle(context.getLocale());
        Map templates = this.getListTemplates(context);
        ListTemplate forum = new ListTemplate(FORUM_LIST_TEMPLATE, bundle.getString("LIST_TEMPLATE_FORUM"), SCHEMAS);
        templates.put(forum.getKey(), forum);
    }

    private void customizeTaskbarItems(CustomizationContext context) {
        TaskbarItems items = this.getTaskbarItems(context);
        TaskbarFactory factory = this.getTaskbarService().getFactory();
        TaskbarItem forum = factory.createCmsTaskbarItem("FORUM", "FORUM_TASK", "glyphicons glyphicons-conversation", "Forum");
        items.add(forum);
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }
}

