/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.edition.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.forum.edition.portlet.model.ForumEditionForm;
import org.osivia.services.forum.edition.portlet.model.ForumEditionMode;
import org.osivia.services.forum.edition.portlet.model.ForumEditionOptions;
import org.osivia.services.forum.edition.portlet.model.Vignette;
import org.osivia.services.forum.edition.portlet.repository.ForumEditionRepository;
import org.osivia.services.forum.edition.portlet.service.ForumEditionService;
import org.osivia.services.forum.util.model.ForumFile;
import org.osivia.services.forum.util.model.ForumFiles;
import org.osivia.services.forum.util.service.AbstractForumServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ForumEditionServiceImpl
extends AbstractForumServiceImpl
implements ForumEditionService {
    private static final String VIGNETTE_TEMPORARY_FILE_PREFIX = "vignette-";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ForumEditionRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INuxeoService nuxeoService;

    public void uploadVignette(PortalControllerContext portalControllerContext, ForumEditionForm form) throws PortletException, IOException {
        Vignette vignette = form.getVignette();
        vignette.setDeleted(false);
        MultipartFile upload = vignette.getUpload();
        this.setAttachmentFileProperties(upload, (ForumFile)vignette, VIGNETTE_TEMPORARY_FILE_PREFIX);
    }

    public void deleteVignette(PortalControllerContext portalControllerContext, ForumEditionForm form) throws PortletException, IOException {
        Vignette vignette = form.getVignette();
        vignette.setDeleted(true);
        File temporaryFile = vignette.getTemporaryFile();
        if (temporaryFile != null) {
            temporaryFile.delete();
            vignette.setTemporaryFile(null);
        }
        vignette.setFileName(null);
        vignette.setMimeType(null);
    }

    public void uploadAttachment(PortalControllerContext portalControllerContext, ForumEditionForm form) throws PortletException, IOException {
        ForumFiles attachments = form.getAttachments();
        ArrayList<ForumFile> files = attachments.getFiles();
        if (files == null) {
            files = new ArrayList<ForumFile>();
            attachments.setFiles(files);
        }
        for (MultipartFile multipartFile : attachments.getUpload()) {
            ForumFile file = (ForumFile)this.applicationContext.getBean(ForumFile.class);
            this.setAttachmentFileProperties(multipartFile, file, "attachment-");
            files.add(file);
        }
    }

    public void deleteAttachment(PortalControllerContext portalControllerContext, ForumEditionForm form) throws PortletException, IOException {
        ForumFiles attachments = form.getAttachments();
        this.deleteAttachment(attachments);
    }

    public void save(PortalControllerContext portalControllerContext, ForumEditionForm form, ForumEditionOptions options) throws PortletException, IOException {
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        this.repository.save(portalControllerContext, form, options);
        String redirectionUrl = this.getRedirectionUrl(portalControllerContext, options, true);
        response.sendRedirect(redirectionUrl);
    }

    public void cancel(PortalControllerContext portalControllerContext, ForumEditionOptions options) throws PortletException, IOException {
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        String redirectionUrl = this.getRedirectionUrl(portalControllerContext, options, false);
        response.sendRedirect(redirectionUrl);
    }

    public void vignettePreview(PortalControllerContext portalControllerContext, ForumEditionForm form) throws PortletException, IOException {
        ResourceResponse response = (ResourceResponse)portalControllerContext.getResponse();
        File temporaryFile = form.getVignette().getTemporaryFile();
        Long size = new Long(temporaryFile.length());
        response.setContentLength(size.intValue());
        String contentType = response.getContentType();
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        response.getCacheControl().setExpirationTime(0);
        FileInputStream inputSteam = new FileInputStream(temporaryFile);
        OutputStream outputStream = response.getPortletOutputStream();
        IOUtils.copy((InputStream)inputSteam, (OutputStream)outputStream);
        outputStream.close();
    }

    public ForumEditionForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        ForumEditionMode mode = ForumEditionMode.fromId((String)window.getProperty("osivia.forum.edition.mode"));
        ForumEditionForm form = (ForumEditionForm)this.applicationContext.getBean(ForumEditionForm.class);
        Vignette vignette = (Vignette)this.applicationContext.getBean(Vignette.class);
        form.setVignette(vignette);
        ForumFiles attachments = (ForumFiles)this.applicationContext.getBean(ForumFiles.class);
        form.setAttachments(attachments);
        if (ForumEditionMode.EDITION.equals((Object)mode)) {
            this.repository.fillDocumentProperties(portalControllerContext, form);
        }
        String documentType = window.getProperty("osivia.forum.edition.documentType");
        form.setDocumentType(documentType);
        return form;
    }

    public ForumEditionOptions getOptions(PortalControllerContext portalControllerContext) throws PortletException {
        INuxeoCustomizer cmsCustomizer = this.nuxeoService.getCMSCustomizer();
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        ForumEditionOptions options = (ForumEditionOptions)this.applicationContext.getBean(ForumEditionOptions.class);
        Map types = cmsCustomizer.getCMSItemTypes();
        DocumentType documentType = (DocumentType)types.get(window.getProperty("osivia.forum.edition.documentType"));
        options.setDocumentType(documentType);
        if (documentType == null) {
            throw new PortletException("Unknown document type.");
        }
        ForumEditionMode mode = ForumEditionMode.fromId((String)window.getProperty("osivia.forum.edition.mode"));
        options.setMode(mode);
        Document document = this.repository.getDocument(portalControllerContext);
        if (ForumEditionMode.CREATION.equals((Object)mode)) {
            String parentPath = document.getPath();
            options.setParentPath(parentPath);
        } else if (ForumEditionMode.EDITION.equals((Object)mode)) {
            options.setDocument(document);
        }
        String fragmentKey = "FORUM_FRAGMENT_" + StringUtils.upperCase((String)documentType.getName());
        String fragment = bundle.getString(fragmentKey);
        options.setFragment(fragment);
        String titleKey = "FORUM_TITLE_" + StringUtils.upperCase((String)mode.getId());
        String title = bundle.getString(titleKey, new Object[]{fragment});
        options.setTitle(title);
        String viewPath = "view-" + StringUtils.lowerCase((String)documentType.getName());
        options.setViewPath(viewPath);
        return options;
    }

    private String getRedirectionUrl(PortalControllerContext portalControllerContext, ForumEditionOptions options, boolean refresh) throws PortletException {
        return this.portalUrlFactory.getBackURL(portalControllerContext, false, refresh);
    }
}

