/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.plugin.menubar;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.services.forum.edition.portlet.model.ForumEditionMode;

public class ForumMenubarModule
implements MenubarModule {
    private static final String FORUM_EDITION_PORTLET_INSTANCE = "osivia-services-forum-edition-instance";
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");

    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext spaceDocumentContext) throws PortalException {
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        if (documentContext != null) {
            DocumentType documentType = documentContext.getDocumentType();
            Document document = (Document)documentContext.getDocument();
            this.removeLock(menubar, documentType);
            MenubarItem addForum = null;
            MenubarItem addThread = null;
            MenubarItem edit = null;
            for (MenubarItem menubarItem : menubar) {
                if ("ADD_FORUM".equals(menubarItem.getId())) {
                    addForum = menubarItem;
                    continue;
                }
                if ("ADD_THREAD".equals(menubarItem.getId())) {
                    addThread = menubarItem;
                    continue;
                }
                if (!"EDIT".equals(menubarItem.getId())) continue;
                edit = menubarItem;
            }
            if (addForum != null) {
                this.customizeAdd(portalControllerContext, document, "Forum", addForum);
            }
            if (addThread != null) {
                this.customizeAdd(portalControllerContext, document, "Thread", addThread);
            }
            if (edit != null && documentType != null && ("Forum".equals(documentType.getName()) || "Thread".equals(documentType.getName()))) {
                this.customizeEdit(portalControllerContext, document, documentType.getName(), edit);
            }
        }
    }

    private void removeLock(List<MenubarItem> menubar, DocumentType documentType) {
        if (documentType != null && "Thread".equals(documentType.getName())) {
            HashSet<MenubarItem> removedItems = new HashSet<MenubarItem>();
            for (MenubarItem menubarItem : menubar) {
                if (!"LOCK_URL".equals(menubarItem.getId())) continue;
                removedItems.add(menubarItem);
            }
            menubar.removeAll(removedItems);
        }
    }

    private void customizeAdd(PortalControllerContext portalControllerContext, Document document, String documentType, MenubarItem menubarItem) throws PortalException {
        String url = this.getUrl(portalControllerContext, document.getPath(), documentType, ForumEditionMode.CREATION);
        menubarItem.setUrl(url);
        menubarItem.setOnclick(null);
        menubarItem.setHtmlClasses(null);
    }

    private void customizeEdit(PortalControllerContext portalControllerContext, Document document, String documentType, MenubarItem menubarItem) throws PortalException {
        String url = this.getUrl(portalControllerContext, document.getPath(), documentType, ForumEditionMode.EDITION);
        menubarItem.setUrl(url);
        menubarItem.setOnclick(null);
        menubarItem.setHtmlClasses(null);
    }

    private String getUrl(PortalControllerContext portalControllerContext, String path, String documentType, ForumEditionMode mode) throws PortalException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.cms.uri", path);
        properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
        properties.put("osivia.ajaxLink", "1");
        properties.put("osivia.forum.edition.documentType", documentType);
        properties.put("osivia.forum.edition.mode", mode.getId());
        return this.portalUrlFactory.getStartPortletUrl(portalControllerContext, FORUM_EDITION_PORTLET_INSTANCE, properties);
    }
}

