/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.ArrayList;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.forum.edition.portlet.model.ForumEditionForm;
import org.osivia.services.forum.edition.portlet.model.ForumEditionOptions;
import org.osivia.services.forum.edition.portlet.repository.ForumEditionRepository;
import org.osivia.services.forum.edition.portlet.repository.command.ForumEditionCommand;
import org.osivia.services.forum.util.model.ForumFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class ForumEditionRepositoryImpl
implements ForumEditionRepository {
    private static final String DOCUMENT_REQUEST_ATTRIBUTE = "osivia.forum.edition.document";
    @Autowired
    private ApplicationContext applicationContext;

    public void save(PortalControllerContext portalControllerContext, ForumEditionForm form, ForumEditionOptions options) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ForumEditionCommand.class, new Object[]{form, options});
        Document document = (Document)nuxeoController.executeNuxeoCommand(command);
        options.setDocument(document);
    }

    public Document getDocument(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        PortletRequest request = portalControllerContext.getRequest();
        Document document = (Document)request.getAttribute(DOCUMENT_REQUEST_ATTRIBUTE);
        if (document == null) {
            NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
            document = documentContext.getDocument();
            request.setAttribute(DOCUMENT_REQUEST_ATTRIBUTE, (Object)document);
        }
        return document;
    }

    public void fillDocumentProperties(PortalControllerContext portalControllerContext, ForumEditionForm form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Document document = this.getDocument(portalControllerContext);
        form.setTitle(document.getTitle());
        form.setDescription(document.getString("dc:description"));
        PropertyMap vignetteMap = document.getProperties().getMap("ttc:vignette");
        if (vignetteMap != null && !vignetteMap.isEmpty()) {
            String vignetteUrl = nuxeoController.createFileLink(document, "ttc:vignette");
            form.getVignette().setUrl(vignetteUrl);
        }
        if ("Thread".equals(document.getType())) {
            form.setMessage(document.getString("ttcth:message"));
            PropertyList attachmentsList = document.getProperties().getList("files:files");
            if (attachmentsList != null && !attachmentsList.isEmpty()) {
                ArrayList<ForumFile> files = form.getAttachments().getFiles();
                if (files == null) {
                    files = new ArrayList<ForumFile>();
                    form.getAttachments().setFiles(files);
                }
                for (int i = 0; i < attachmentsList.size(); ++i) {
                    MimeType mimeType;
                    PropertyMap attachmentMap = attachmentsList.getMap(i);
                    PropertyMap attachmentFileMap = attachmentMap.getMap("file");
                    String fileName = attachmentFileMap.getString("name");
                    try {
                        mimeType = new MimeType(attachmentFileMap.getString("mime-type"));
                    }
                    catch (MimeTypeParseException e) {
                        mimeType = null;
                    }
                    ForumFile file = (ForumFile)this.applicationContext.getBean(ForumFile.class);
                    file.setBlobIndex(Integer.valueOf(i));
                    file.setFileName(fileName);
                    file.setMimeType(mimeType);
                    files.add(file);
                }
            }
        }
    }
}

