/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.util.service;

import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.osivia.services.forum.util.model.ForumFile;
import org.osivia.services.forum.util.model.ForumFiles;
import org.osivia.services.forum.util.model.comparator.ForumBlobIndexComparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractForumServiceImpl {
    protected static final String ATTACHMENT_TEMPORARY_FILE_PREFIX = "attachment-";
    private static final String TEMPORARY_FILE_SUFFIX = ".tmp";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ForumBlobIndexComparator blobIndexComparator;

    protected void uploadAttachments(ForumFiles attachments) throws IOException {
        ArrayList<ForumFile> files = attachments.getFiles();
        if (files == null) {
            files = new ArrayList<ForumFile>();
            attachments.setFiles(files);
        }
        for (MultipartFile multipartFile : attachments.getUpload()) {
            ForumFile file = (ForumFile)this.applicationContext.getBean(ForumFile.class);
            this.setAttachmentFileProperties(multipartFile, file, ATTACHMENT_TEMPORARY_FILE_PREFIX);
            files.add(file);
        }
    }

    protected void setAttachmentFileProperties(MultipartFile upload, ForumFile file, String prefix) throws IOException {
        MimeType mimeType;
        File temporaryFile = file.getTemporaryFile();
        if (temporaryFile != null) {
            temporaryFile.delete();
        }
        temporaryFile = File.createTempFile(prefix, TEMPORARY_FILE_SUFFIX);
        temporaryFile.deleteOnExit();
        upload.transferTo(temporaryFile);
        file.setTemporaryFile(temporaryFile);
        String s = Normalizer.normalize(upload.getOriginalFilename(), Normalizer.Form.NFC);
        file.setFileName(s);
        try {
            mimeType = new MimeType(upload.getContentType());
        }
        catch (MimeTypeParseException e) {
            mimeType = null;
        }
        file.setMimeType(mimeType);
    }

    protected void deleteAttachment(ForumFiles attachments) throws IOException {
        Integer deletedIndex = attachments.getDeletedIndex();
        if (deletedIndex != null) {
            File temporaryFile;
            List files = attachments.getFiles();
            ForumFile file = (ForumFile)files.get(deletedIndex);
            Integer blobIndex = file.getBlobIndex();
            if (blobIndex != null) {
                TreeSet<Integer> deletedBlobIndexes = attachments.getDeletedBlobIndexes();
                if (deletedBlobIndexes == null) {
                    deletedBlobIndexes = new TreeSet<Integer>((Comparator<Integer>)this.blobIndexComparator);
                    attachments.setDeletedBlobIndexes(deletedBlobIndexes);
                }
                deletedBlobIndexes.add(blobIndex);
            }
            if ((temporaryFile = file.getTemporaryFile()) != null) {
                temporaryFile.delete();
            }
            files.remove(file);
        }
        attachments.setDeletedIndex(null);
    }
}

