/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.thread.portlet.model;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ForumThreadParserContext {
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private PersonService personService;
    private final PortalControllerContext portalControllerContext;

    public ForumThreadParserContext() {
        this(null);
    }

    public ForumThreadParserContext(PortalControllerContext portalControllerContext) {
        this.portalControllerContext = portalControllerContext;
    }

    public String getBlockquoteHeader(String id, String author) throws PortletException, IOException {
        Person person;
        PortletRequest portletRequest = this.portalControllerContext.getRequest();
        Bundle bundle = this.bundleFactory.getBundle(portletRequest.getLocale());
        String displayName = author == null ? "" : ((person = this.personService.getPerson(author)) == null ? author : StringUtils.defaultIfBlank((String)person.getDisplayName(), (String)author));
        Element header = DOM4JUtils.generateElement((String)"p", (String)"blockquote-header", null);
        DOM4JUtils.addAttribute((Element)header, (String)"contenteditable", (String)String.valueOf(false));
        Element linkContainer = DOM4JUtils.generateElement((String)"strong", null, null);
        header.add(linkContainer);
        Element link = DOM4JUtils.generateLinkElement((String)("#" + id), null, null, null, (String)bundle.getString("FORUM_THREAD_USER_QUOTE", new Object[]{displayName}));
        DOM4JUtils.addTooltip((Element)link, (String)bundle.getString("FORUM_THREAD_USER_QUOTE_TOOLTIP"));
        linkContainer.add(link);
        return DOM4JUtils.writeCompact((Element)header);
    }
}

