/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.onlyoffice.plugin;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.services.onlyoffice.portlet.model.FileUtility;

public class OnlyofficeMenubarModule
implements MenubarModule {
    private static final String ONLYOFFICE_PORTLET_INSTANCE = "osivia-services-onlyoffice-portletInstance";
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final IBundleFactory bundleFactory;

    public OnlyofficeMenubarModule() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext<? extends EcmDocument> spaceDocumentContext) throws PortalException {
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext<? extends EcmDocument> documentContext) throws PortalException {
        EcmDocument document = documentContext.getDoc();
        BasicPermissions basicPermissions = (BasicPermissions)documentContext.getPermissions(BasicPermissions.class);
        if (basicPermissions.isEditableByUser() && document != null && document instanceof Document) {
            String mimeType;
            Document nuxeoDocument = (Document)document;
            String type = nuxeoDocument.getType();
            String documentPath = nuxeoDocument.getPath();
            PropertyMap properties = nuxeoDocument.getProperties();
            PropertyMap fileContent = properties.getMap("file:content");
            if (StringUtils.isNotBlank((String)type) && StringUtils.isNotBlank((String)documentPath) && fileContent != null && FileUtility.isMimeTypeSupported((String)(mimeType = fileContent.getString("mime-type")))) {
                MenubarItem item;
                NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
                Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                if (nuxeoDocument.isLocked()) {
                    item = new MenubarItem("LIVE_EDIT", bundle.getString("LIVE_EDIT"), "halflings halflings-pencil", (MenubarContainer)parent, 0, "#", null, null, null);
                    item.isDisabled();
                } else {
                    HashMap<String, String> windowProperties = new HashMap<String, String>();
                    windowProperties.put("osivia.cms.uri", documentPath);
                    windowProperties.put("osivia.hideTitle", "1");
                    windowProperties.put("osivia.title", bundle.getString("LIVE_EDIT"));
                    String url = nuxeoController.getPortalUrlFactory().getStartPortletUrl(portalControllerContext, ONLYOFFICE_PORTLET_INSTANCE, windowProperties);
                    item = new MenubarItem("LIVE_EDIT", bundle.getString("LIVE_EDIT"), "halflings halflings-pencil", (MenubarContainer)parent, 0, url, null, null, null);
                }
                menubar.add(item);
            }
        }
    }
}

