/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.onlyoffice.portlet.service.impl;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.Locale;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.onlyoffice.portlet.command.GetUserJWTTokenCommand;
import org.osivia.services.onlyoffice.portlet.model.EditorConfig;
import org.osivia.services.onlyoffice.portlet.model.EditorConfigCustomization;
import org.osivia.services.onlyoffice.portlet.model.FileUtility;
import org.osivia.services.onlyoffice.portlet.model.OnlyOfficeDocument;
import org.osivia.services.onlyoffice.portlet.model.OnlyOfficeUser;
import org.osivia.services.onlyoffice.portlet.model.OnlyofficeConfig;
import org.osivia.services.onlyoffice.portlet.service.IOnlyofficeService;
import org.springframework.stereotype.Service;

@Service
public class OnlyofficeImpl
implements IOnlyofficeService {
    private static final String WEBSERVICE_CALLBACKEDIT_PATH = "/site/onlyoffice/callbackEdit/";
    private static final String ONLYOFFICE_TOKEN_ID = System.getProperty("osivia.onlyoffice.token.id", "onlyoffice");
    private static final String ONLYOFFICE_NUXEO_URL = System.getProperty("osivia.onlyoffice.nuxeo.url", "");
    private static final String ONLYOFFICE_LANG = System.getProperty("osivia.onlyoffice.lang", "fr-FR");
    private final PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);

    private String getWindowProperty(PortletRequest request, String property) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        return window.getProperty(property);
    }

    private PropertyMap getCurrentFileContent(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap properties = this.getCurrentProperties(portletRequest, portletResponse, portletContext);
        PropertyMap fileContent = properties.getMap("file:content");
        return fileContent;
    }

    private PropertyMap getCurrentProperties(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        Document currentDoc = this.getCurrentDoc(portletRequest, portletResponse, portletContext);
        PropertyMap properties = currentDoc.getProperties();
        return properties;
    }

    private Document getCurrentDoc(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portletRequest, portletResponse, portletContext);
        Document currentDoc = nuxeoController.getCurrentDoc();
        if (currentDoc == null) {
            NuxeoDocumentContext documentContext;
            String path = this.getWindowProperty(portletRequest, "osivia.cms.uri");
            try {
                documentContext = NuxeoController.getDocumentContext((PortletRequest)portletRequest, (PortletResponse)portletResponse, (PortletContext)portletContext, (String)path);
            }
            catch (PortletException e) {
                throw new PortletException((Throwable)e);
            }
            Document document = documentContext.getDoc();
            nuxeoController.setCurrentDoc(document);
            currentDoc = nuxeoController.getCurrentDoc();
        }
        return currentDoc;
    }

    private String getMode(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)portletRequest, (PortletResponse)portletResponse, (PortletContext)portletContext);
        BasicPermissions permissions = (BasicPermissions)documentContext.getPermissions(BasicPermissions.class);
        if (permissions.isEditableByUser()) {
            return "edit";
        }
        return "view";
    }

    private String getDocUrl(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap fileContent = this.getCurrentFileContent(portletRequest, portletResponse, portletContext);
        String docUrl = fileContent.getString("data");
        NuxeoController nuxeoController = new NuxeoController(portletRequest, portletResponse, portletContext);
        String userToken = (String)nuxeoController.executeNuxeoCommand((INuxeoCommand)new GetUserJWTTokenCommand(ONLYOFFICE_TOKEN_ID));
        if (StringUtils.contains((String)docUrl, (String)"/nxbigfile/")) {
            int indexOf = StringUtils.indexOf((String)docUrl, (String)"/nxbigfile/");
            docUrl = ONLYOFFICE_NUXEO_URL + StringUtils.substring((String)docUrl, (int)indexOf) + "?token=" + userToken;
        } else if (StringUtils.contains((String)docUrl, (String)"/nxfile/")) {
            int indexOf = StringUtils.indexOf((String)docUrl, (String)"/nxfile/");
            docUrl = ONLYOFFICE_NUXEO_URL + StringUtils.substring((String)docUrl, (int)indexOf) + "?token=" + userToken;
        } else {
            docUrl = "";
        }
        return docUrl;
    }

    private String getDocFileType(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        String filename = this.getDocTitle(portletRequest, portletResponse, portletContext);
        String docExtension = StringUtils.substringAfterLast((String)filename, (String)".");
        return docExtension;
    }

    private String getDocKey(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        Document currentDoc = this.getCurrentDoc(portletRequest, portletResponse, portletContext);
        String docKey = currentDoc.getId() + "." + currentDoc.getLastModified().getTime();
        return docKey;
    }

    private String getDocTitle(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap fileContent = this.getCurrentFileContent(portletRequest, portletResponse, portletContext);
        String filename = fileContent.getString("name");
        return filename;
    }

    private String getCallbackUrl(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        Document currentDoc = this.getCurrentDoc(portletRequest, portletResponse, portletContext);
        String currentDocId = currentDoc.getId();
        return ONLYOFFICE_NUXEO_URL + WEBSERVICE_CALLBACKEDIT_PATH + currentDocId;
    }

    private String getDocumentType(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap fileContent = this.getCurrentFileContent(portletRequest, portletResponse, portletContext);
        String mimeType = fileContent.getString("mime-type");
        return FileUtility.GetFileType((String)mimeType).name();
    }

    public String getOnlyOfficeConfig(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        OnlyofficeConfig onlyOfficeConfig = new OnlyofficeConfig();
        OnlyOfficeDocument onlyOfficeDocument = new OnlyOfficeDocument();
        onlyOfficeDocument.setFileType(this.getDocFileType(portletRequest, portletResponse, portletContext));
        onlyOfficeDocument.setKey(this.getDocKey(portletRequest, portletResponse, portletContext));
        onlyOfficeDocument.setTitle(this.getDocTitle(portletRequest, portletResponse, portletContext));
        onlyOfficeDocument.setUrl(this.getDocUrl(portletRequest, portletResponse, portletContext));
        onlyOfficeConfig.setDocument(onlyOfficeDocument);
        onlyOfficeConfig.setDocumentType(this.getDocumentType(portletRequest, portletResponse, portletContext));
        EditorConfig onlyOfficeEditorConfig = new EditorConfig();
        onlyOfficeEditorConfig.setCallbackUrl(this.getCallbackUrl(portletRequest, portletResponse, portletContext));
        onlyOfficeEditorConfig.setUser(this.buildOnlyOfficeUser(portletRequest.getUserPrincipal().getName()));
        onlyOfficeEditorConfig.setMode(this.getMode(portletRequest, portletResponse, portletContext));
        onlyOfficeEditorConfig.setLang(this.getLang(portletRequest.getLocale()));
        EditorConfigCustomization editorConfigCustomization = new EditorConfigCustomization();
        editorConfigCustomization.setChat(true);
        onlyOfficeEditorConfig.setCustomization(editorConfigCustomization);
        onlyOfficeConfig.setEditorConfig(onlyOfficeEditorConfig);
        JSONObject onlyOfficeConfigJson = JSONObject.fromObject((Object)onlyOfficeConfig);
        return onlyOfficeConfigJson.toString();
    }

    private String getLang(Locale locale) {
        return ONLYOFFICE_LANG;
    }

    private OnlyOfficeUser buildOnlyOfficeUser(String uid) {
        OnlyOfficeUser user = new OnlyOfficeUser();
        user.setId(uid);
        Person person = this.personService.getPerson(uid);
        if (person != null) {
            user.setName(person.getDisplayName());
        } else {
            user.setName(uid);
        }
        return user;
    }
}

