/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.onlyoffice.portlet.service.impl;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.liveedit.OnlyofficeLiveEditHelper;
import java.security.Principal;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Locale;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.onlyoffice.portlet.command.GetUserJWTTokenCommand;
import org.osivia.services.onlyoffice.portlet.model.EditorConfig;
import org.osivia.services.onlyoffice.portlet.model.EditorConfigCustomization;
import org.osivia.services.onlyoffice.portlet.model.EditorConfigCustomizationGoback;
import org.osivia.services.onlyoffice.portlet.model.OnlyOfficeDocument;
import org.osivia.services.onlyoffice.portlet.model.OnlyOfficeUser;
import org.osivia.services.onlyoffice.portlet.model.OnlyofficeConfig;
import org.osivia.services.onlyoffice.portlet.service.IOnlyofficeService;
import org.osivia.services.onlyoffice.portlet.service.impl.ExtendedDocumentInfosCommand;
import org.osivia.services.onlyoffice.portlet.service.impl.IsDocumentCurrentlyEditedCommand;
import org.osivia.services.onlyoffice.portlet.service.impl.LockTemporaryCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OnlyofficeImpl
implements IOnlyofficeService {
    private static final String ANONYMOUS_NAME = "Utilisateur invit\u00e9";
    private static final String ANONYMOUS_LOGIN = "Anonymous";
    private static final String WEBSERVICE_CALLBACKEDIT_PATH = "/site/onlyoffice/callbackEdit/";
    private static final String ONLYOFFICE_TOKEN_ID = System.getProperty("osivia.onlyoffice.token.id", "onlyoffice");
    private static final String ONLYOFFICE_NUXEO_URL = System.getProperty("osivia.onlyoffice.nuxeo.url", "");
    private static final String ONLYOFFICE_LANG = System.getProperty("osivia.onlyoffice.lang", "fr-FR");
    private final PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
    private final IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;

    public OnlyofficeImpl() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    private String getWindowProperty(PortletRequest request, String property) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        return window.getProperty(property);
    }

    private PropertyMap getCurrentFileContent(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap properties = this.getCurrentProperties(portletRequest, portletResponse, portletContext);
        PropertyMap fileContent = properties.getMap("file:content");
        return fileContent;
    }

    private PropertyMap getCurrentProperties(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        Document currentDoc = this.getCurrentDoc(portletRequest, portletResponse, portletContext);
        PropertyMap properties = currentDoc.getProperties();
        return properties;
    }

    private Document getCurrentDoc(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portletRequest, portletResponse, portletContext);
        Document currentDoc = nuxeoController.getCurrentDoc();
        if (currentDoc == null) {
            NuxeoDocumentContext documentContext;
            String path = this.getWindowProperty(portletRequest, "osivia.cms.uri");
            try {
                documentContext = NuxeoController.getDocumentContext((PortletRequest)portletRequest, (PortletResponse)portletResponse, (PortletContext)portletContext, (String)path);
            }
            catch (PortletException e) {
                throw new PortletException((Throwable)e);
            }
            Document document = documentContext.getDoc();
            nuxeoController.setCurrentDoc(document);
            currentDoc = nuxeoController.getCurrentDoc();
        }
        return currentDoc;
    }

    private String getMode(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext, String documentPath) throws PortletException {
        NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)portletRequest, (PortletResponse)portletResponse, (PortletContext)portletContext, (String)documentPath);
        BasicPermissions permissions = (BasicPermissions)documentContext.getPermissions(BasicPermissions.class);
        if (permissions.isEditableByUser()) {
            return "edit";
        }
        return "view";
    }

    private String getDocUrl(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap fileContent = this.getCurrentFileContent(portletRequest, portletResponse, portletContext);
        String docUrl = fileContent.getString("data");
        NuxeoController nuxeoController = new NuxeoController(portletRequest, portletResponse, portletContext);
        String userToken = (String)nuxeoController.executeNuxeoCommand((INuxeoCommand)new GetUserJWTTokenCommand(ONLYOFFICE_TOKEN_ID));
        if (StringUtils.contains((String)docUrl, (String)"/nxbigfile/")) {
            int indexOf = StringUtils.indexOf((String)docUrl, (String)"/nxbigfile/");
            docUrl = ONLYOFFICE_NUXEO_URL + StringUtils.substring((String)docUrl, (int)indexOf) + "?token=" + userToken;
        } else if (StringUtils.contains((String)docUrl, (String)"/nxfile/")) {
            int indexOf = StringUtils.indexOf((String)docUrl, (String)"/nxfile/");
            docUrl = ONLYOFFICE_NUXEO_URL + StringUtils.substring((String)docUrl, (int)indexOf) + "?token=" + userToken;
        } else {
            docUrl = "";
        }
        return docUrl;
    }

    private String getDocFileType(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        String filename = this.getDocTitle(portletRequest, portletResponse, portletContext);
        String docExtension = StringUtils.substringAfterLast((String)filename, (String)".");
        return docExtension;
    }

    private String getDocKey(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        Document currentDoc = this.getCurrentDoc(portletRequest, portletResponse, portletContext);
        String docKey = currentDoc.getId() + "." + currentDoc.getLastModified().getTime();
        return docKey;
    }

    private String getDocTitle(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap fileContent = this.getCurrentFileContent(portletRequest, portletResponse, portletContext);
        String filename = fileContent.getString("name");
        return filename;
    }

    private String getCallbackUrl(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        Document currentDoc = this.getCurrentDoc(portletRequest, portletResponse, portletContext);
        String currentDocId = currentDoc.getId();
        return ONLYOFFICE_NUXEO_URL + WEBSERVICE_CALLBACKEDIT_PATH + currentDocId;
    }

    private String getDocumentType(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap fileContent = this.getCurrentFileContent(portletRequest, portletResponse, portletContext);
        String mimeType = fileContent.getString("mime-type");
        return OnlyofficeLiveEditHelper.getFileType((String)mimeType).name();
    }

    private EditorConfigCustomizationGoback getGoback(Bundle bundle, PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) {
        EditorConfigCustomizationGoback goback = new EditorConfigCustomizationGoback();
        goback.setText(bundle.getString("BACK_TEXT"));
        NuxeoController nuxeoController = new NuxeoController(portletRequest, portletResponse, portletContext);
        Document currentDoc = null;
        try {
            currentDoc = this.getCurrentDoc(portletRequest, portletResponse, portletContext);
        }
        catch (PortletException portletException) {
            // empty catch block
        }
        PortalControllerContext pcc = new PortalControllerContext(portletContext, portletRequest, portletResponse);
        HashMap<String, String> properties = new HashMap<String, String>();
        String backURL = nuxeoController.getPortalUrlFactory().getBackURL(nuxeoController.getPortalCtx(), false);
        backURL = StringUtils.isNotEmpty((String)backURL) ? backURL.replace("/pagemarker", "/refresh/pagemarker") : nuxeoController.getLink(currentDoc, "menu").getUrl();
        properties.put("backURL", backURL);
        properties.put("osivia.title", bundle.getString("CLOSING"));
        properties.put("id", currentDoc.getId());
        properties.put("action", "close");
        String toCloseUrl = "";
        try {
            toCloseUrl = nuxeoController.getPortalUrlFactory().getStartPortletUrl(pcc, "osivia-services-onlyoffice-portletInstance", properties);
        }
        catch (PortalException portalException) {
            // empty catch block
        }
        goback.setUrl(toCloseUrl);
        return goback;
    }

    public String getOnlyOfficeConfig(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext, String documentPath) throws PortletException {
        OnlyofficeConfig onlyOfficeConfig = new OnlyofficeConfig();
        OnlyOfficeDocument onlyOfficeDocument = new OnlyOfficeDocument();
        onlyOfficeDocument.setFileType(this.getDocFileType(portletRequest, portletResponse, portletContext));
        onlyOfficeDocument.setKey(this.getDocKey(portletRequest, portletResponse, portletContext));
        String escapeTitle = this.getDocTitle(portletRequest, portletResponse, portletContext);
        onlyOfficeDocument.setTitle(escapeTitle.replaceAll("'", " "));
        String escapeUrl = this.getDocUrl(portletRequest, portletResponse, portletContext);
        onlyOfficeDocument.setUrl(escapeUrl.replaceAll("'", ""));
        onlyOfficeConfig.setDocument(onlyOfficeDocument);
        onlyOfficeConfig.setDocumentType(this.getDocumentType(portletRequest, portletResponse, portletContext));
        EditorConfig onlyOfficeEditorConfig = new EditorConfig();
        onlyOfficeEditorConfig.setCallbackUrl(this.getCallbackUrl(portletRequest, portletResponse, portletContext));
        onlyOfficeEditorConfig.setUser(this.buildOnlyOfficeUser(portletRequest.getUserPrincipal()));
        onlyOfficeEditorConfig.setMode(this.getMode(portletRequest, portletResponse, portletContext, documentPath));
        onlyOfficeEditorConfig.setLang(this.getLang(portletRequest.getLocale()));
        EditorConfigCustomization editorConfigCustomization = new EditorConfigCustomization();
        editorConfigCustomization.setChat(true);
        Bundle bundle = this.bundleFactory.getBundle(portletRequest.getLocale());
        editorConfigCustomization.setGoback(this.getGoback(bundle, portletRequest, portletResponse, portletContext));
        onlyOfficeEditorConfig.setCustomization(editorConfigCustomization);
        onlyOfficeConfig.setEditorConfig(onlyOfficeEditorConfig);
        JSONObject onlyOfficeConfigJson = JSONObject.fromObject((Object)onlyOfficeConfig);
        return onlyOfficeConfigJson.toString();
    }

    private String getLang(Locale locale) {
        return ONLYOFFICE_LANG;
    }

    private OnlyOfficeUser buildOnlyOfficeUser(Principal userPrincipal) {
        OnlyOfficeUser user = new OnlyOfficeUser();
        String id = ANONYMOUS_LOGIN;
        if (userPrincipal != null) {
            id = userPrincipal.getName();
            Person person = this.personService.getPerson(id);
            if (person != null) {
                String displayName = person.getDisplayName().replace("'", " ");
                user.setName(displayName);
            } else {
                user.setName(id);
            }
        } else {
            user.setName(ANONYMOUS_NAME);
        }
        user.setId(id);
        return user;
    }

    public boolean waitForRefresh(PortalControllerContext pcc, String uuid) {
        JSONArray usernamesArray;
        JSONObject currentlyEditedEntry;
        boolean editedByMe = false;
        boolean editedByOthers = false;
        Principal principal = pcc.getRequest().getUserPrincipal();
        NuxeoController controller = new NuxeoController(pcc);
        IsDocumentCurrentlyEditedCommand command = new IsDocumentCurrentlyEditedCommand(uuid);
        JSONObject info = (JSONObject)controller.executeNuxeoCommand((INuxeoCommand)command);
        if (info != null && info.containsKey((Object)"isCurrentlyEdited") && info.getBoolean("isCurrentlyEdited") && (currentlyEditedEntry = info.getJSONObject("currentlyEditedEntry")) != null && (usernamesArray = currentlyEditedEntry.getJSONArray("username")) != null) {
            ListIterator userNamesI = usernamesArray.listIterator();
            while (userNamesI.hasNext()) {
                String userName = (String)userNamesI.next();
                if (principal != null && StringUtils.equals((String)principal.getName(), (String)userName)) {
                    editedByMe = true;
                    continue;
                }
                editedByOthers = true;
            }
        }
        return editedByMe && !editedByOthers;
    }

    public boolean askForLocking(NuxeoController nuxeoController) throws PortletException {
        Document currentDoc = this.getCurrentDoc(nuxeoController.getRequest(), nuxeoController.getResponse(), nuxeoController.getPortletCtx());
        ExtendedDocumentInfosCommand command = new ExtendedDocumentInfosCommand(currentDoc.getPath());
        ExtendedDocumentInfos info = (ExtendedDocumentInfos)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        Bundle bundle = this.bundleFactory.getBundle(nuxeoController.getRequest().getLocale());
        if (info.isCurrentlyEdited()) {
            this.notificationsService.addSimpleNotification(nuxeoController.getPortalCtx(), bundle.getString("CURRENTLY_EDITED"), NotificationsType.WARNING);
            return false;
        }
        if (info.getLockStatus() != null && info.getLockStatus().equals((Object)ExtendedDocumentInfos.LockStatus.locked)) {
            this.notificationsService.addSimpleNotification(nuxeoController.getPortalCtx(), bundle.getString("CURRENTLY_LOCKED"), NotificationsType.WARNING);
            return false;
        }
        return true;
    }

    public void lockTemporary(NuxeoController nuxeoController) throws PortletException {
        Document currentDoc = this.getCurrentDoc(nuxeoController.getRequest(), nuxeoController.getResponse(), nuxeoController.getPortletCtx());
        LockTemporaryCommand command = new LockTemporaryCommand(currentDoc.getId());
        JSONObject info = (JSONObject)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        String error = info.getString("error");
        if ("1".equals(error)) {
            Bundle bundle = this.bundleFactory.getBundle(nuxeoController.getRequest().getLocale());
            this.notificationsService.addSimpleNotification(nuxeoController.getPortalCtx(), bundle.getString("LOCK_ERROR"), NotificationsType.ERROR);
        }
    }
}

