/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.pad.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.Cookie;
import net.sf.json.JSONObject;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.pad.portlet.controller.PadModel;
import org.osivia.services.pad.portlet.service.PadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class PadController
extends CMSPortlet
implements PortletConfigAware,
PortletContextAware {
    @Autowired
    private PadService service;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationService;
    private PortletConfig portletConfig;
    private PortletContext portletContext;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="pad") PadModel pad) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        PortalControllerContext pcc = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        JSONObject obj = this.service.joinRequest(pcc, pad.getEditionMode());
        if (obj.containsKey((Object)"error")) {
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            String message = bundle.getString("PAD_UNAVALIABLE");
            this.notificationService.addSimpleNotification(pcc, message, NotificationsType.ERROR);
            return "paderror";
        }
        if (obj.containsKey((Object)"sessionId")) {
            Cookie cookie = new Cookie("sessionID", obj.getString("sessionId"));
            response.addProperty(cookie);
        }
        pad.setUrl(obj.getString("url"));
        Boolean canEdit = Boolean.valueOf(window.getProperty("osivia.service.pad.canEdit"));
        if (canEdit.booleanValue()) {
            this.addMenubarOptions(request, response, pad);
        }
        return "view";
    }

    @ModelAttribute(value="pad")
    public PadModel getPad(PortletRequest request, PortletResponse response) {
        PadModel pad = new PadModel();
        return pad;
    }

    private void addMenubarOptions(RenderRequest request, RenderResponse response, PadModel pad) {
        List menubar = (List)request.getAttribute("osivia.menuBar");
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        PortletURL actionURL = response.createActionURL();
        actionURL.setParameter("javax.portlet.action", "switchMode");
        if (!pad.getEditionMode().booleanValue()) {
            actionURL.setParameter("editionMode", "true");
            MenubarItem menubarItem = new MenubarItem("ENTER_PAD", bundle.getString("ENTER_PAD"), null, (MenubarContainer)MenubarGroup.SPECIFIC, 1, actionURL.toString(), null, null, null);
            menubar.add(menubarItem);
        } else {
            actionURL.setParameter("editionMode", "false");
            MenubarItem menubarItem = new MenubarItem("LEAVE_PAD", bundle.getString("LEAVE_PAD"), null, (MenubarContainer)MenubarGroup.SPECIFIC, 1, actionURL.toString(), null, null, null);
            menubar.add(menubarItem);
        }
    }

    @ActionMapping(value="switchMode")
    public void switchMode(ActionRequest request, @ModelAttribute(value="pad") PadModel pad) {
        Boolean editionMode = Boolean.parseBoolean(request.getParameter("editionMode"));
        pad.setEditionMode(editionMode);
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

