/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.drools;

import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderErrors;
import org.drools.rule.Package;
import org.osivia.services.procedure.portlet.drools.Context;
import org.osivia.services.procedure.portlet.drools.Datas;
import org.osivia.services.procedure.portlet.model.ProcedureModel;

public class DatasInjection {
    private ProcedureModel model;
    private Map<String, String> globalVariablesValues;
    private String ruleContext;

    public void shouldFire(ProcedureModel model, Map<String, String> globalVariablesValues, String ruleContext) throws FormFilterException {
        this.model = model;
        this.globalVariablesValues = globalVariablesValues;
        this.ruleContext = ruleContext;
        try {
            RuleBase ruleBase = this.initialiseDrools();
            WorkingMemory workingMemory = this.initializeMessageObjects(ruleBase);
            int n = workingMemory.fireAllRules();
        }
        catch (Exception e) {
            if (e.getCause() instanceof FormFilterException) {
                throw (FormFilterException)e.getCause();
            }
            throw new FormFilterException((Throwable)e);
        }
    }

    private RuleBase initialiseDrools() throws IOException, DroolsParserException {
        PackageBuilder packageBuilder = this.readRuleFiles();
        return this.addRulesToWorkingMemory(packageBuilder);
    }

    private PackageBuilder readRuleFiles() throws DroolsParserException, IOException {
        PackageBuilder packageBuilder = new PackageBuilder();
        StringReader reader = new StringReader(this.model.getRules());
        packageBuilder.addPackageFromDrl((Reader)reader);
        this.assertNoRuleErrors(packageBuilder);
        return packageBuilder;
    }

    private RuleBase addRulesToWorkingMemory(PackageBuilder packageBuilder) {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Package rulesPackage = packageBuilder.getPackage();
        ruleBase.addPackage(rulesPackage);
        return ruleBase;
    }

    private void assertNoRuleErrors(PackageBuilder packageBuilder) {
        PackageBuilderErrors errors = packageBuilder.getErrors();
        if (errors.getErrors().length > 0) {
            StringBuilder errorMessages = new StringBuilder();
            errorMessages.append("Found errors in package builder\n");
            for (int i = 0; i < errors.getErrors().length; ++i) {
                DroolsError errorMessage = errors.getErrors()[i];
                errorMessages.append(errorMessage);
                errorMessages.append("\n");
            }
            errorMessages.append("Could not parse knowledge");
            throw new IllegalArgumentException(errorMessages.toString());
        }
    }

    private WorkingMemory initializeMessageObjects(RuleBase ruleBase) {
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        this.createHelloWorld((WorkingMemory)workingMemory);
        return workingMemory;
    }

    private void createHelloWorld(WorkingMemory workingMemory) {
        Context context = new Context(this.ruleContext);
        Datas datas = new Datas(this.globalVariablesValues, this.model);
        workingMemory.insert((Object)datas);
        workingMemory.insert((Object)context);
    }
}

