/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class Record {
    private String procedureModelWebId;
    private Map<String, String> globalVariablesValues;
    private String creator;
    private Date created;
    private String lastContributor;
    private Date modified;
    private final Document originalDocument;

    public Record(Document document) {
        this.originalDocument = document;
        this.globalVariablesValues = new HashMap();
        PropertyMap documentProperties = document.getProperties();
        PropertyMap gvvList = documentProperties.getMap("rcd:globalVariablesValues");
        if (gvvList != null) {
            for (Map.Entry gvvO : gvvList.getMap().entrySet()) {
                this.globalVariablesValues.put(gvvO.getKey(), (String)gvvO.getValue());
            }
        }
        this.setProcedureModelWebId(documentProperties.getString("rcd:procedureModelWebId"));
        this.setCreator(documentProperties.getString("dc:creator"));
        this.setCreated(documentProperties.getDate("dc:created"));
        this.setLastContributor(documentProperties.getString("dc:lastContributor"));
        this.setModified(documentProperties.getDate("dc:modified"));
    }

    public Map<String, JSON> getJsonValues() {
        HashMap<String, JSONArray> jsonValues;
        if (MapUtils.isEmpty((Map)this.globalVariablesValues)) {
            jsonValues = null;
        } else {
            jsonValues = new HashMap<String, JSONArray>(this.globalVariablesValues.size());
            for (Map.Entry entry : this.globalVariablesValues.entrySet()) {
                Object json;
                String name = (String)entry.getKey();
                String value = StringUtils.trim((String)((String)entry.getValue()));
                try {
                    json = StringUtils.startsWith((String)value, (String)"[") ? JSONArray.fromObject((Object)value) : (StringUtils.startsWith((String)value, (String)"{") ? JSONObject.fromObject((Object)value) : null);
                }
                catch (JSONException e) {
                    json = null;
                }
                if (json == null) continue;
                jsonValues.put(name, (JSONArray)json);
            }
        }
        return jsonValues;
    }

    public String getProcedureModelWebId() {
        return this.procedureModelWebId;
    }

    public void setProcedureModelWebId(String procedureModelWebId) {
        this.procedureModelWebId = procedureModelWebId;
    }

    public Map<String, String> getGlobalVariablesValues() {
        return this.globalVariablesValues;
    }

    public void setGlobalVariablesValues(Map<String, String> globalVariablesValues) {
        this.globalVariablesValues = globalVariablesValues;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getLastContributor() {
        return this.lastContributor;
    }

    public void setLastContributor(String lastContributor) {
        this.lastContributor = lastContributor;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Document getOriginalDocument() {
        return this.originalDocument;
    }
}

