/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.formFilters;

import com.sun.mail.smtp.SMTPTransport;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterParameterType;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.services.procedure.formFilters.SendMailFilter;

public class SendMailFilter
implements FormFilter {
    private static final Log LOGGER = LogFactory.getLog(SendMailFilter.class);
    public static final String ID = "SendMailFilter";
    private static final String LABEL_KEY = "SEND_MAIL_FILTER_LABEL";
    private static final String DESCRIPTION_KEY = "SEND_MAIL_FILTER_DESCRIPTION";
    private static final String BODY_PARAMETER = "body";
    private static final String MAIL_TO_PARAMETER = "mailTo";
    private static final String MAIL_FROM_PARAMETER = "mailFrom";
    private static final String MAIL_OBJECT_PARAMETER = "mailObject";
    private static final String CONTINUE_PARAMETER = "continue";
    private IBundleFactory bundleFactory;
    private INotificationsService notificationService;

    public SendMailFilter() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.notificationService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
    }

    public String getId() {
        return ID;
    }

    public String getLabelKey() {
        return LABEL_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public Map<String, FormFilterParameterType> getParameters() {
        HashMap<String, FormFilterParameterType> parameters = new HashMap<String, FormFilterParameterType>();
        parameters.put(MAIL_TO_PARAMETER, FormFilterParameterType.TEXT);
        parameters.put(MAIL_OBJECT_PARAMETER, FormFilterParameterType.TEXT);
        parameters.put(MAIL_FROM_PARAMETER, FormFilterParameterType.TEXT);
        parameters.put(BODY_PARAMETER, FormFilterParameterType.TEXTAREA);
        parameters.put(CONTINUE_PARAMETER, FormFilterParameterType.BOOLEAN);
        return parameters;
    }

    public boolean hasChildren() {
        return false;
    }

    public void execute(FormFilterContext context, FormFilterExecutor executor) throws FormFilterException {
        InternetAddress[] mailToAddr;
        String defaultFrom;
        PortalControllerContext portalControllerContext = context.getPortalControllerContext();
        Locale locale = null;
        if (portalControllerContext.getRequest() != null) {
            locale = portalControllerContext.getRequest().getLocale();
        }
        Bundle bundle = this.bundleFactory.getBundle(locale);
        String mailFromVar = context.getParamValue(executor, MAIL_FROM_PARAMETER);
        String mailToVar = context.getParamValue(executor, MAIL_TO_PARAMETER);
        String mailObjectVar = context.getParamValue(executor, MAIL_OBJECT_PARAMETER);
        String mailBodyVar = context.getParamValue(executor, BODY_PARAMETER);
        boolean continueEvenIfError = BooleanUtils.toBoolean((String)context.getParamValue(executor, CONTINUE_PARAMETER));
        StringBuilder body = new StringBuilder();
        for (String line : StringUtils.split((String)mailBodyVar, (String)System.lineSeparator())) {
            body.append("<p>");
            body.append(line);
            body.append("</p>");
        }
        Properties properties = System.getProperties();
        String userName = properties.getProperty("mail.smtp.user");
        String password = properties.getProperty("mail.smtp.password");
        SMTPAuthenticator auth = null;
        if (userName != null && password != null) {
            auth = new SMTPAuthenticator(this, userName, password);
        }
        Session mailSession = Session.getInstance((Properties)properties, auth);
        MimeMessage message = new MimeMessage(mailSession);
        InternetAddress mailFromAddr = null;
        if (StringUtils.isNotBlank((String)mailFromVar)) {
            try {
                mailFromAddr = new InternetAddress(mailFromVar);
            }
            catch (AddressException e1) {
                throw new FormFilterException(bundle.getString("SEND_MAIL_FILTER_MAILFROM_MISSING_ERROR"));
            }
        }
        if (mailFromAddr == null && StringUtils.isNotEmpty((String)(defaultFrom = System.getProperty("mail.replyTo")))) {
            try {
                mailFromAddr = new InternetAddress(defaultFrom);
            }
            catch (AddressException e1) {
                throw new FormFilterException(bundle.getString("SEND_MAIL_FILTER_MAILFROM_MISSING_ERROR"));
            }
        }
        try {
            mailToAddr = InternetAddress.parse((String)mailToVar, (boolean)false);
        }
        catch (AddressException e1) {
            throw new FormFilterException(bundle.getString("SEND_MAIL_FILTER_MAILTO_MISSING_ERROR"));
        }
        try {
            message.setFrom((Address)mailFromAddr);
            message.setRecipients(Message.RecipientType.TO, (Address[])mailToAddr);
            message.setSubject(mailObjectVar, "UTF-8");
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)body.toString(), "text/html; charset=UTF-8");
            multipart.addBodyPart((BodyPart)htmlPart);
            message.setContent((Multipart)multipart);
            message.setSentDate(new Date());
            if (mailFromAddr != null) {
                InternetAddress[] replyToTab = new InternetAddress[]{mailFromAddr};
                message.setReplyTo((Address[])replyToTab);
            }
            SMTPTransport transport = (SMTPTransport)mailSession.getTransport();
            transport.connect();
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (MessagingException e) {
            if (continueEvenIfError) {
                String errorMsg = bundle.getString("SEND_MAIL_FILTER_NOTIFICATION_ERROR");
                this.notificationService.addSimpleNotification(portalControllerContext, errorMsg, NotificationsType.ERROR);
                LOGGER.error((Object)errorMsg, (Throwable)e);
            }
            throw new FormFilterException((Throwable)e);
        }
    }
}

