/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.osivia.services.procedure.portlet.model.NuxeoOperationEnum;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ListRecordsCommand
implements INuxeoCommand {
    private final String basePath;
    private final String recordFolderWebId;
    private final String filter;

    private ListRecordsCommand(String basePath, String recordFolderWebId, String filter) {
        this.basePath = basePath;
        this.recordFolderWebId = recordFolderWebId;
        this.filter = filter;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:primaryType = 'Record' ");
        if (StringUtils.isNotEmpty((String)this.basePath)) {
            clause.append("AND ecm:path STARTSWITH '").append(this.basePath).append("' ");
        }
        if (StringUtils.isNotBlank((String)this.recordFolderWebId)) {
            clause.append("AND rcd:procedureModelWebId = '").append(this.recordFolderWebId).append("' ");
        }
        if (StringUtils.isNotBlank((String)this.filter)) {
            clause.append("AND (dc:title ILIKE '").append(this.filter).append("%' or ecm:fulltext = '").append(this.filter).append("' ) ");
        }
        clause.append("ORDER BY dc:title ASC");
        NuxeoQueryFilterContext filter = new NuxeoQueryFilterContext(1, "local");
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)filter, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest(NuxeoOperationEnum.QueryElasticSearch.getId());
        request.set("X-NXDocumentProperties", (Object)"dublincore, toutatice");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("|");
        builder.append(StringUtils.trimToEmpty((String)this.basePath));
        builder.append("|");
        builder.append(StringUtils.trimToEmpty((String)this.recordFolderWebId));
        builder.append("|");
        builder.append(StringUtils.trimToEmpty((String)this.filter));
        return builder.toString();
    }
}

