/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.configuration;

import fr.toutatice.portail.cms.nuxeo.api.portlet.CmsPortletConfiguration;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.portlet.multipart.CommonsPortletMultipartResolver;
import org.springframework.web.portlet.multipart.PortletMultipartResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Configuration
@ComponentScan(basePackages={"org.osivia.services.procedure.portlet"})
public class ProcedurePortletConfiguration
extends CmsPortletConfiguration {
    @Bean
    public InternalResourceViewResolver getViewResolver() {
        InternalResourceViewResolver viewResolver = new InternalResourceViewResolver();
        viewResolver.setCache(true);
        viewResolver.setViewClass(JstlView.class);
        viewResolver.setPrefix("/WEB-INF/jsp/");
        viewResolver.setSuffix(".jsp");
        return viewResolver;
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("Resource");
        return messageSource;
    }

    @Bean(name={"portletMultipartResolver"})
    public PortletMultipartResolver getMultipartResolver() {
        CommonsPortletMultipartResolver multipartResolver = new CommonsPortletMultipartResolver();
        multipartResolver.setDefaultEncoding("UTF-8");
        multipartResolver.setMaxUploadSizePerFile(0xA00000L);
        return multipartResolver;
    }

    @Bean
    public INotificationsService getNotificationService() {
        return (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
    }

    @Bean
    public INuxeoService getNuxeoService() {
        return (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    }

    @Bean
    public GroupService getGroupService() {
        return (GroupService)DirServiceFactory.getService(GroupService.class);
    }

    @Bean
    public DocumentDAO getDocumentDao() {
        return DocumentDAO.getInstance();
    }
}

