/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.feedRss.portlet.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.io.IOUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.services.rss.common.model.FeedRssModel;
import org.osivia.services.rss.common.service.FeedService;
import org.osivia.services.rss.feedRss.portlet.validator.ModifFormValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"}, params={"edit=feed"})
@SessionAttributes(value={"form"})
public class EditFeedController {
    @Autowired
    protected PortletContext portletContext;
    @Autowired
    public ApplicationContext applicationContext;
    @Autowired
    protected FeedService service;
    @Autowired
    private ModifFormValidator formValidator;
    @Autowired
    protected IBundleFactory bundleFactory;
    @Autowired
    protected INotificationsService notificationsService;
    public static final String DISPLAY = "displayName";
    public static final String URL = "url";
    public static final String ID = "id";
    public static final String INDEX = "index";
    protected static final String FEED_ATTRIBUTE = "form";

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute FeedRssModel form) throws PortletException {
        return "editFeed";
    }

    @ActionMapping(value="del")
    public void del(ActionRequest request, ActionResponse response, @RequestParam String id, @ModelAttribute(value="form") FeedRssModel form, SessionStatus status) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.delFeed(portalControllerContext, form);
        status.setComplete();
    }

    @ActionMapping(value="modif")
    public void modif(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="form") FeedRssModel form, BindingResult result, SessionStatus status) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (result.hasErrors()) {
            response.setRenderParameter("edit", "feed");
        } else {
            this.service.modFeed(portalControllerContext, form);
            status.setComplete();
        }
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.formValidator});
    }

    @ModelAttribute(value="form")
    public FeedRssModel getForm(PortletRequest request, PortletResponse response, @RequestParam(value="id", required=false) String id, @RequestParam(value="displayName", required=false) String name, @RequestParam(value="url", required=false) String url, @RequestParam(value="index", required=false) String index) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getMapFeed(portalControllerContext, id, name, url, Integer.parseInt(index));
    }

    @ActionMapping(value="cancel")
    public void cancel(ActionRequest request, ActionResponse response, SessionStatus status) {
        status.setComplete();
    }

    @ActionMapping(name="modif", params={"upload-visual"})
    public void uploadVisual(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") FeedRssModel form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.uploadVisual(portalControllerContext, form);
        response.setRenderParameter("edit", "feed");
    }

    @ActionMapping(name="modif", params={"delete-visual"})
    public void deleteVisual(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") FeedRssModel form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deleteVisual(portalControllerContext, form);
        response.setRenderParameter("edit", "feed");
    }

    @ResourceMapping(value="visualPreview")
    public void visualPreview(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") FeedRssModel form) throws IOException {
        File temporaryFile = form.getVisual().getTemporaryFile();
        Long size = temporaryFile.length();
        response.setContentLength(size.intValue());
        String contentType = response.getContentType();
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        response.getCacheControl().setExpirationTime(0);
        FileInputStream inputSteam = new FileInputStream(temporaryFile);
        OutputStream outputStream = response.getPortletOutputStream();
        IOUtils.copy((InputStream)inputSteam, (OutputStream)outputStream);
        outputStream.close();
    }
}

