/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.common.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.osivia.services.rss.common.model.ContainerRssModel;
import org.osivia.services.rss.common.model.Picture;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class FeedCreatCommand
implements INuxeoCommand {
    private ContainerRssModel form;
    private String mode;
    protected static final Log logger = LogFactory.getLog(FeedCreatCommand.class);

    public FeedCreatCommand(ContainerRssModel form, String mode) {
        this.form = form;
        this.mode = mode;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        Picture visual;
        OperationRequest request;
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        DocRef parent = new DocRef(this.form.getPath());
        Document document = this.form.doc;
        if (this.mode.equalsIgnoreCase("del")) {
            request = nuxeoSession.newRequest("Document.RemoveProperty");
            request.setInput((OperationInput)document);
            request.set("xpath", (Object)("rssc:feeds/" + this.form.getFeed().getIndexNuxeo()));
            request.execute();
        }
        if (this.mode.equalsIgnoreCase("add")) {
            request = nuxeoSession.newRequest("Document.AddComplexProperty");
            String feedSource = this.setFeed();
            request.setInput((OperationInput)document);
            request.set("xpath", (Object)"rssc:feeds");
            request.set("value", (Object)feedSource);
            request.execute();
        }
        if (this.mode.equalsIgnoreCase("mod")) {
            String path = "rssc:feeds/" + this.form.getFeed().getIndexNuxeo() + "/" + "displayName";
            documentService.setProperty(parent, path, this.form.getFeed().getDisplayName());
        }
        if ((visual = this.form.getVisual()) != null) {
            if (visual.isUpdated()) {
                File temporaryFile = visual.getTemporaryFile();
                FileBlob blob = new FileBlob(temporaryFile);
                blob.setFileName(visual.getName());
                documentService.setBlob((DocRef)this.form.doc, (Blob)blob, "rssc:feeds/" + this.form.getFeed().getIndexNuxeo() + "/" + "logos");
                temporaryFile.delete();
            } else if (visual.isDeleted()) {
                documentService.removeBlob((DocRef)this.form.doc, "rssc:feeds/" + this.form.getFeed().getIndexNuxeo() + "/" + "logos");
            }
        }
        return document;
    }

    public String getId() {
        return null;
    }

    private String setFeed() {
        String feed = null;
        if (this.form.getFeed().getSyncId() == null) {
            this.form.getFeed().setSyncId(UUID.randomUUID().toString());
        }
        String id = "syncId=" + this.form.getFeed().getSyncId() + "\n";
        String displayName = "displayName=" + this.form.getFeed().getDisplayName() + "\n";
        String url = "url=" + this.form.getFeed().getUrl().toString();
        feed = id + displayName + url;
        return feed;
    }
}

