/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.rss.common.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.rss.common.command.ContainerCreatCommand;
import org.osivia.services.rss.common.command.ContainerListCommand;
import org.osivia.services.rss.common.command.ContainerRemoveCommand;
import org.osivia.services.rss.common.command.ContainerUpdateCommand;
import org.osivia.services.rss.common.model.ContainerRssModel;
import org.osivia.services.rss.common.repository.ContainerRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class ContainerRepositoryImpl
implements ContainerRepository {
    @Autowired
    public ApplicationContext applicationContext;

    public List<ContainerRssModel> getListContainerRss(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController;
        if (portalControllerContext.getRequest() == null) {
            nuxeoController = new NuxeoController(portalControllerContext.getPortletCtx());
            nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        } else {
            nuxeoController = new NuxeoController(portalControllerContext);
        }
        INuxeoCommand nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(ContainerListCommand.class);
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(nuxeoCommand);
        ArrayList<ContainerRssModel> containers = new ArrayList<ContainerRssModel>(documents.size());
        for (Document document : documents) {
            ContainerRssModel container = this.fillContainer(document, nuxeoController);
            containers.add(container);
        }
        return containers;
    }

    private ContainerRssModel fillContainer(Document document, NuxeoController nuxeoController) {
        String name = document.getString("dc:title");
        ContainerRssModel container = (ContainerRssModel)this.applicationContext.getBean(ContainerRssModel.class);
        container.setName(name);
        container.setDoc(document);
        DocumentDTO dto = DocumentDAO.getInstance().toDTO(document);
        container.setDocument(dto);
        return container;
    }

    public void creatContainer(PortalControllerContext portalControllerContext, ContainerRssModel model) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(ContainerCreatCommand.class, new Object[]{model});
        nuxeoController.executeNuxeoCommand(nuxeoCommand);
    }

    public Set<String> getMapContainer(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        HashSet<String> map = new HashSet<String>();
        INuxeoCommand nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(ContainerListCommand.class);
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(nuxeoCommand);
        for (Document document : documents) {
            map.add(document.getString("dc:title"));
        }
        return map;
    }

    public void remove(PortalControllerContext portalControllerContext, String docid) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(ContainerRemoveCommand.class, new Object[]{docid});
        nuxeoController.executeNuxeoCommand(nuxeoCommand);
    }

    public void modifContainer(PortalControllerContext portalControllerContext, ContainerRssModel model) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand nuxeoCommand = (INuxeoCommand)this.applicationContext.getBean(ContainerUpdateCommand.class, new Object[]{model});
        nuxeoController.executeNuxeoCommand(nuxeoCommand);
    }
}

