/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.search.common.repository;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.services.search.common.repository.CommonRepository;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonRepositoryImpl
implements CommonRepository {
    @Autowired
    private ICMSServiceLocator cmsServiceLocator;

    public Document getRoot(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setForcePublicationInfosScope("superuser_context");
        String basePath = nuxeoController.getBasePath();
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        Document workspace = null;
        try {
            while (workspace == null && StringUtils.isNotEmpty((String)basePath)) {
                CMSPublicationInfos publicationInfos = cmsService.getPublicationInfos(cmsContext, basePath);
                CMSItem spaceConfig = cmsService.getSpaceConfig(cmsContext, basePath);
                DocumentType documentType = spaceConfig.getType();
                if (documentType != null && ("Workspace".equals(documentType.getName()) || "PortalSite".equals(documentType.getName()))) {
                    workspace = (Document)spaceConfig.getNativeItem();
                    continue;
                }
                basePath = publicationInfos.getParentSpaceID();
            }
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
        return workspace;
    }
}

