/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.statistics.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.PostConstruct;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.statistics.model.StatisticsConfiguration;
import org.osivia.services.statistics.repository.IStatisticsRepository;
import org.osivia.services.statistics.service.IStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class StatisticsViewController
extends CMSPortlet
implements PortletContextAware,
PortletConfigAware {
    @Autowired
    private IStatisticsService service;
    @Autowired
    private IStatisticsRepository repository;
    private PortletContext portletContext;
    private PortletConfig portletConfig;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ResourceMapping(value="loadStatistics")
    public void loadStatistics(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="configuration") StatisticsConfiguration configuration) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        String data = this.service.loadData(portalControllerContext, configuration);
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(data);
        printWriter.close();
    }

    @ModelAttribute(value="configuration")
    public StatisticsConfiguration getConfiguration(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.repository.getConfiguration(portalControllerContext);
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}

