/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.statistics.service;

import java.util.Map;
import javax.portlet.PortletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.statistics.model.StatisticsConfiguration;
import org.osivia.services.statistics.repository.IStatisticsRepository;
import org.osivia.services.statistics.service.IStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServiceImpl
implements IStatisticsService {
    @Autowired
    private IStatisticsRepository repository;

    public String loadData(PortalControllerContext portalControllerContext, StatisticsConfiguration configuration) throws PortletException {
        Map periods = this.repository.getDocumentsCountByPeriods(portalControllerContext, configuration);
        JSONArray labels = new JSONArray();
        JSONArray values = new JSONArray();
        for (Map.Entry period : periods.entrySet()) {
            labels.add(period.getKey());
            values.add(period.getValue());
        }
        JSONObject dataset = new JSONObject();
        dataset.put((Object)"label", (Object)"Exemple");
        dataset.put((Object)"fillColor", (Object)"rgba(151, 187, 205, 0.5)");
        dataset.put((Object)"strokeColor", (Object)"rgba(151, 187, 205, 0.8");
        dataset.put((Object)"highlightFill", (Object)"rgba(151, 187, 205, 0.75");
        dataset.put((Object)"highlightStroke", (Object)"rgba(151, 187, 205, 1");
        dataset.put((Object)"data", (Object)values);
        JSONArray datasets = new JSONArray();
        datasets.add((Object)dataset);
        JSONObject data = new JSONObject();
        data.put((Object)"labels", (Object)labels);
        data.put((Object)"datasets", (Object)datasets);
        return data.toString();
    }
}

