/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.statistics.portlet.controller;

import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONObject;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.statistics.portlet.model.StatisticsForm;
import org.osivia.services.statistics.portlet.service.StatisticsPortletService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form"})
public class StatisticsViewController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private StatisticsPortletService service;

    @RenderMapping
    public String viewCreations(RenderRequest request, RenderResponse response) {
        return "view/view-creations";
    }

    @RenderMapping(params={"tab=visits"})
    public String viewVisits(RenderRequest request, RenderResponse response) {
        return "view/view-visits";
    }

    @ActionMapping(value="changeView")
    public void changeView(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") StatisticsForm form) throws PortletException {
        response.setRenderParameter("tab", request.getParameter("tab"));
    }

    @ResourceMapping(value="creations")
    public void loadCreations(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") StatisticsForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        JSONObject data = this.service.getCreations(portalControllerContext, form.getCreationsView());
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(data.toString());
        printWriter.close();
    }

    @ResourceMapping(value="visits")
    public void loadVisits(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") StatisticsForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        JSONObject data = this.service.getVisits(portalControllerContext, form.getVisitsView());
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(data.toString());
        printWriter.close();
    }

    @ModelAttribute(value="form")
    public StatisticsForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }
}

