/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.statistics.portlet.service;

import java.util.Map;
import javax.portlet.PortletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.dom4j.Element;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.services.statistics.portlet.model.StatisticsConfiguration;
import org.osivia.services.statistics.portlet.model.StatisticsView;
import org.osivia.services.statistics.portlet.repository.IStatisticsRepository;
import org.osivia.services.statistics.portlet.service.IStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServiceImpl
implements IStatisticsService {
    @Autowired
    private IStatisticsRepository repository;

    public String loadData(PortalControllerContext portalControllerContext, StatisticsConfiguration configuration) throws PortletException {
        Map periods = this.repository.getDocumentsCountsByPeriods(portalControllerContext, configuration);
        int index = StatisticsView.DIFFERENTIAL.equals((Object)configuration.getView()) ? 0 : 1;
        JSONArray labels = new JSONArray();
        JSONArray values = new JSONArray();
        for (Map.Entry period : periods.entrySet()) {
            labels.add(period.getKey());
            values.add((Object)((Integer[])period.getValue())[index]);
        }
        JSONObject dataset = new JSONObject();
        dataset.put((Object)"label", (Object)"-");
        dataset.put((Object)"fillColor", (Object)"rgba(151, 187, 205, 0.5)");
        dataset.put((Object)"strokeColor", (Object)"rgba(151, 187, 205, 0.8");
        dataset.put((Object)"highlightFill", (Object)"rgba(151, 187, 205, 0.75");
        dataset.put((Object)"highlightStroke", (Object)"rgba(151, 187, 205, 1");
        dataset.put((Object)"data", (Object)values);
        JSONArray datasets = new JSONArray();
        datasets.add((Object)dataset);
        JSONObject chart = new JSONObject();
        chart.put((Object)"labels", (Object)labels);
        chart.put((Object)"datasets", (Object)datasets);
        Element tbody = DOM4JUtils.generateElement((String)"tbody", null, (String)"");
        for (Map.Entry period : periods.entrySet()) {
            Element tr = DOM4JUtils.generateElement((String)"tr", null, null);
            tbody.add(tr);
            Element label = DOM4JUtils.generateElement((String)"td", null, (String)((String)period.getKey()));
            tr.add(label);
            for (int i = 0; i < 2; ++i) {
                Element value = DOM4JUtils.generateElement((String)"td", null, (String)String.valueOf(((Integer[])period.getValue())[i]));
                tr.add(value);
            }
        }
        JSONObject data = new JSONObject();
        data.put((Object)"chart", (Object)chart);
        data.put((Object)"table", (Object)DOM4JUtils.write((Element)tbody));
        return data.toString();
    }
}

