/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.taskbar.common.repository;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.panels.PanelPlayer;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.taskbar.common.model.Task;
import org.osivia.services.taskbar.common.model.TaskbarConfiguration;
import org.osivia.services.taskbar.common.model.TaskbarView;
import org.osivia.services.taskbar.common.repository.ITaskbarRepository;
import org.springframework.stereotype.Repository;

@Repository
public class TaskbarRepositoryImpl
implements ITaskbarRepository {
    private static final String ORDER_WINDOW_PROPERTY = "osivia.taskbar.order";
    private static final String VIEW_WINDOW_PROPERTY = "osivia.taskbar.view";
    private static final String ORDER_SEPARATOR = "|";
    private final ITaskbarService taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
    private final IPortalUrlFactory portalURLFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IBundleFactory bundleFactory;

    public TaskbarRepositoryImpl() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public TaskbarConfiguration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        List<String> order;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        TaskbarConfiguration configuration = new TaskbarConfiguration();
        String orderProperty = window.getProperty(ORDER_WINDOW_PROPERTY);
        if (orderProperty == null) {
            order = this.initOrder();
            window.setProperty(ORDER_WINDOW_PROPERTY, StringUtils.join(order, (String)ORDER_SEPARATOR));
        } else {
            order = Arrays.asList(StringUtils.split((String)orderProperty, (String)ORDER_SEPARATOR));
        }
        configuration.setOrder(order);
        TaskbarView view = TaskbarView.fromName((String)window.getProperty(VIEW_WINDOW_PROPERTY));
        configuration.setView(view);
        return configuration;
    }

    private List<String> initOrder() {
        ArrayList<String> orderedTasks = new ArrayList<String>(2);
        orderedTasks.add("HOME");
        orderedTasks.add("CMS_NAVIGATION");
        return orderedTasks;
    }

    public void saveConfiguration(PortalControllerContext portalControllerContext, TaskbarConfiguration configuration) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        window.setProperty(ORDER_WINDOW_PROPERTY, StringUtils.join((Collection)configuration.getOrder(), (String)ORDER_SEPARATOR));
        window.setProperty(VIEW_WINDOW_PROPERTY, configuration.getView().getName());
    }

    public List<TaskbarTask> getNavigationTasks(PortalControllerContext portalControllerContext) throws PortletException {
        List<Object> navigationTasks;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String basePath = nuxeoController.getBasePath();
        if (StringUtils.isEmpty((String)basePath)) {
            navigationTasks = new ArrayList<TaskbarTask>(0);
        } else {
            try {
                navigationTasks = this.taskbarService.getTasks(portalControllerContext, basePath, true);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return navigationTasks;
    }

    public TaskbarTask createRemainingTask(PortalControllerContext portalControllerContext, TaskbarItem item) throws PortletException {
        TaskbarFactory factory = this.taskbarService.getFactory();
        return factory.createTaskbarTask(item, null, false);
    }

    public TaskbarItems getTaskbarItems(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarItems items;
        try {
            items = this.taskbarService.getItems(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return items;
    }

    public void updateTasks(PortalControllerContext portalControllerContext, List<Task> tasks) throws PortletException {
        String activeId;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        try {
            activeId = this.taskbarService.getActiveId(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        for (Task task : tasks) {
            String url;
            task.setActive(StringUtils.equals((String)activeId, (String)task.getId()));
            String displayName = task.getKey() != null ? bundle.getString(task.getKey(), task.getCustomizedClassLoader(), new Object[0]) : task.getTitle();
            task.setDisplayName(displayName);
            if ("HOME".equals(task.getId())) {
                url = this.portalURLFactory.getCMSUrl(portalControllerContext, null, nuxeoController.getBasePath(), null, null, "taskbar", null, null, "1", null);
            } else if (task.getPlayer() != null) {
                PanelPlayer player = task.getPlayer();
                HashMap<String, String> properties = new HashMap<String, String>();
                if (player.getProperties() != null) {
                    properties.putAll(player.getProperties());
                }
                properties.put("osivia.taskbar.id", task.getId());
                if (task.getDisplayName() != null) {
                    properties.put("osivia.title", task.getDisplayName());
                }
                properties.put("osivia.back.reset", String.valueOf(true));
                properties.put("osivia.navigation.reset", String.valueOf(true));
                try {
                    url = this.portalURLFactory.getStartPortletUrl(portalControllerContext, player.getInstance(), properties);
                }
                catch (PortalException e) {
                    throw new PortletException((Throwable)e);
                }
            } else {
                url = task.getPath() != null ? this.portalURLFactory.getCMSUrl(portalControllerContext, null, task.getPath(), null, null, "taskbar", null, null, "1", null) : "#";
            }
            task.setUrl(url);
        }
    }

    public TaskbarItem createVirtualItem(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarFactory factory = this.taskbarService.getFactory();
        return factory.createTransversalTaskbarItem("CMS_NAVIGATION", "CMS_NAVIGATION_TASK", "glyphicons glyphicons-magic", null);
    }
}

