/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.taskbar.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.taskbar.portlet.model.Task;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CreateSearchStapleCommand
implements INuxeoCommand {
    private final String basePath;
    private final Task task;

    private CreateSearchStapleCommand(String basePath, Task task) {
        this.basePath = basePath;
        this.task = task;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        Document workspace = documentService.getDocument(new DocRef(this.basePath), "*");
        String workspaceId = workspace.getString("webc:url");
        String webId = this.getWebId(workspaceId);
        Document document = this.getTaskDocument(nuxeoSession, webId);
        if (document == null) {
            PropertyMap properties = new PropertyMap();
            properties.set("dc:title", this.task.getDisplayName());
            properties.set("ttc:showInMenu", Boolean.valueOf(true));
            properties.set("ttc:webid", webId);
            document = documentService.createDocument((DocRef)workspace, "Staple", null, properties);
        } else if (BooleanUtils.isNotTrue((Boolean)document.getProperties().getBoolean("ttc:showInMenu"))) {
            PropertyMap properties = new PropertyMap();
            properties.set("ttc:showInMenu", Boolean.valueOf(true));
            document = documentService.update((DocRef)document, properties);
        }
        return document;
    }

    private String getWebId(String workspaceId) {
        StringBuilder webId = new StringBuilder();
        webId.append("workspace_");
        webId.append(workspaceId);
        webId.append("_");
        webId.append(StringUtils.lowerCase((String)this.task.getId()));
        return webId.toString();
    }

    private Document getTaskDocument(Session nuxeoSession, String webId) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ttc:webid = '").append(webId).append("' ");
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        Documents results = (Documents)request.execute();
        Document task = results.size() == 1 ? (Document)results.iterator().next() : null;
        return task;
    }

    public String getId() {
        return null;
    }
}

