/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.taskbar.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.panels.PanelPlayer;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItemType;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.taskbar.portlet.model.Task;
import org.osivia.services.taskbar.portlet.model.TaskbarSettings;
import org.osivia.services.taskbar.portlet.model.TaskbarView;
import org.osivia.services.taskbar.portlet.repository.TaskbarRepository;
import org.osivia.services.taskbar.portlet.repository.command.CreateSearchStapleCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class TaskbarRepositoryImpl
implements TaskbarRepository {
    private static final String ORDER_WINDOW_PROPERTY = "osivia.taskbar.order";
    private static final String VIEW_WINDOW_PROPERTY = "osivia.taskbar.view";
    private static final String TASKBAR_DISPLAY_CONTEXT = "taskbar";
    private static final String ORDER_SEPARATOR = "|";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ITaskbarService taskbarService;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;

    public TaskbarSettings getSettings(PortalControllerContext portalControllerContext) throws PortletException {
        List<String> order;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        TaskbarSettings settings = new TaskbarSettings();
        String orderProperty = window.getProperty(ORDER_WINDOW_PROPERTY);
        if (orderProperty == null) {
            order = this.initOrder();
            window.setProperty(ORDER_WINDOW_PROPERTY, StringUtils.join(order, (String)ORDER_SEPARATOR));
        } else {
            order = Arrays.asList(StringUtils.split((String)orderProperty, (String)ORDER_SEPARATOR));
        }
        settings.setOrder(order);
        TaskbarView view = TaskbarView.fromName((String)window.getProperty(VIEW_WINDOW_PROPERTY));
        settings.setView(view);
        return settings;
    }

    private List<String> initOrder() {
        ArrayList<String> orderedTasks = new ArrayList<String>(2);
        orderedTasks.add("HOME");
        orderedTasks.add("CMS_NAVIGATION");
        return orderedTasks;
    }

    public void saveSettings(PortalControllerContext portalControllerContext, TaskbarSettings settings) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        window.setProperty(ORDER_WINDOW_PROPERTY, StringUtils.join((Collection)settings.getOrder(), (String)ORDER_SEPARATOR));
        window.setProperty(VIEW_WINDOW_PROPERTY, settings.getView().getName());
    }

    public List<TaskbarTask> getNavigationTasks(PortalControllerContext portalControllerContext) throws PortletException {
        List<Object> navigationTasks;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String basePath = nuxeoController.getBasePath();
        if (StringUtils.isEmpty((String)basePath)) {
            navigationTasks = new ArrayList<TaskbarTask>(0);
        } else {
            try {
                navigationTasks = this.taskbarService.getTasks(portalControllerContext, basePath);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return navigationTasks;
    }

    public TaskbarTask createRemainingTask(PortalControllerContext portalControllerContext, TaskbarItem item) throws PortletException {
        TaskbarFactory factory = this.taskbarService.getFactory();
        return factory.createTaskbarTask(item, null, null, false);
    }

    public TaskbarItems getTaskbarItems(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarItems items;
        try {
            items = this.taskbarService.getItems(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return items;
    }

    public void updateTasks(PortalControllerContext portalControllerContext, List<Task> tasks) throws PortletException {
        String activeId;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        try {
            activeId = this.taskbarService.getActiveId(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        for (Task task : tasks) {
            String url;
            task.setActive(StringUtils.equals((String)activeId, (String)task.getId()));
            String displayName = task.getKey() != null ? bundle.getString(task.getKey(), task.getCustomizedClassLoader(), new Object[0]) : task.getTitle();
            task.setDisplayName(displayName);
            if ("SEARCH".equals(task.getId()) && TaskbarItemType.STAPLED.equals((Object)task.getType()) && StringUtils.isEmpty((String)task.getPath())) {
                this.createSearchStaple(portalControllerContext, task);
            }
            if ("HOME".equals(task.getId())) {
                url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, nuxeoController.getBasePath(), null, null, TASKBAR_DISPLAY_CONTEXT, null, null, null, null);
            } else if (task.getPlayer() != null) {
                PanelPlayer player = task.getPlayer();
                HashMap<String, String> properties = new HashMap<String, String>();
                if (player.getProperties() != null) {
                    properties.putAll(player.getProperties());
                }
                properties.put("osivia.taskbar.id", task.getId());
                if (task.getDisplayName() != null) {
                    properties.put("osivia.title", task.getDisplayName());
                }
                properties.put("osivia.back.reset", String.valueOf(true));
                properties.put("osivia.navigation.reset", String.valueOf(true));
                try {
                    url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, player.getInstance(), properties);
                }
                catch (PortalException e) {
                    throw new PortletException((Throwable)e);
                }
            } else {
                url = StringUtils.isNotEmpty((String)task.getPath()) ? this.portalUrlFactory.getCMSUrl(portalControllerContext, null, task.getPath(), null, null, TASKBAR_DISPLAY_CONTEXT, null, null, null, null) : "#";
            }
            task.setUrl(url);
        }
    }

    private void createSearchStaple(PortalControllerContext portalControllerContext, Task task) {
        PortletRequest request = portalControllerContext.getRequest();
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        String basePath = nuxeoController.getBasePath();
        if (StringUtils.isNotEmpty((String)basePath)) {
            INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(CreateSearchStapleCommand.class, new Object[]{basePath, task});
            Document document = (Document)nuxeoController.executeNuxeoCommand(command);
            task.setPath(document.getPath());
            request.setAttribute("osivia.updateContents", (Object)String.valueOf(true));
        }
    }

    public TaskbarItem createVirtualItem(PortalControllerContext portalControllerContext) throws PortletException {
        TaskbarFactory factory = this.taskbarService.getFactory();
        return factory.createTransversalTaskbarItem("CMS_NAVIGATION", "CMS_NAVIGATION_TASK", "glyphicons glyphicons-magic", null);
    }
}

