/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.tasks.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class GetTasksCommand
implements INuxeoCommand {
    private final String user;
    private final String path;

    public GetTasksCommand(String user) {
        this(user, null);
    }

    public GetTasksCommand(String user, String path) {
        this.user = user;
        this.path = path;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document ");
        query.append("WHERE ecm:primaryType = 'TaskDoc' ");
        query.append("AND ecm:currentLifeCycleState = 'opened' ");
        query.append("AND nt:task_variables.notifiable = 'true' ");
        query.append("AND nt:actors = '").append(this.user).append("' ");
        if (StringUtils.isNotEmpty((String)this.path)) {
            query.append("AND ecm:path = '").append(this.path).append("' ");
        }
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore, task");
        request.set("query", (Object)query.toString());
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("/");
        builder.append(this.user);
        if (StringUtils.isNotEmpty((String)this.path)) {
            builder.append("/");
            builder.append(this.path);
        }
        return builder.toString();
    }
}

