/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.tasks.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.services.tasks.portlet.model.Task;
import org.osivia.services.tasks.portlet.model.TaskActionType;
import org.osivia.services.tasks.portlet.model.Tasks;
import org.osivia.services.tasks.portlet.repository.GetTasksCommand;
import org.osivia.services.tasks.portlet.repository.TasksRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class TasksRepositoryImpl
implements TasksRepository {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PersonService personService;
    @Autowired
    private IFormsService formsService;

    public List<Task> getTasks(PortalControllerContext portalControllerContext) throws PortletException {
        ArrayList<Object> tasks;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Principal principal = portalControllerContext.getRequest().getUserPrincipal();
        if (principal == null) {
            tasks = new ArrayList<Task>(0);
        } else {
            String user = principal.getName();
            INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetTasksCommand.class, new Object[]{user});
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
            tasks = new ArrayList(documents.size());
            for (Document document : documents.list()) {
                PropertyMap taskVariables = document.getProperties().getMap("nt:task_variables");
                Task task = (Task)this.applicationContext.getBean(Task.class);
                task.setDocument(document);
                task.setDisplay(this.getTaskDisplay(portalControllerContext, document));
                task.setDate(document.getDate("dc:created"));
                task.setAcknowledgeable(BooleanUtils.isTrue((Boolean)taskVariables.getBoolean("acquitable")));
                task.setCloseable(BooleanUtils.isTrue((Boolean)taskVariables.getBoolean("closable")));
                tasks.add(task);
            }
        }
        return tasks;
    }

    private String getTaskDisplay(PortalControllerContext portalControllerContext, Document task) throws PortletException {
        String transformedExpression;
        PropertyMap instanceProperties = task.getProperties().getMap("nt:pi");
        PropertyMap globalVariables = instanceProperties.getMap("pi:globalVariablesValues");
        PropertyMap taskVariables = task.getProperties().getMap("nt:task_variables");
        String expression = taskVariables.getString("stringMsg");
        HashMap variables = new HashMap(globalVariables.size() + taskVariables.size());
        for (Map.Entry entry : globalVariables.getMap().entrySet()) {
            variables.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        for (Map.Entry entry : taskVariables.getMap().entrySet()) {
            variables.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        variables.put("initiator", task.getString("nt:initiator"));
        try {
            transformedExpression = this.formsService.transform(portalControllerContext, expression, variables);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return transformedExpression;
    }

    public void updateTask(PortalControllerContext portalControllerContext, Tasks tasks, Task task, TaskActionType actionType) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Principal principal = portalControllerContext.getRequest().getUserPrincipal();
        String user = principal.getName();
        String path = task.getDocument().getPath();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetTasksCommand.class, new Object[]{user, path});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        Document document = documents.get(0);
        PropertyMap taskVariables = document.getProperties().getMap("nt:task_variables");
        String actionId = taskVariables.getString(actionType.getActionReference());
        try {
            this.formsService.proceed(portalControllerContext, document, actionId, null);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public static String getUserLink(String user) {
        Element link = DOM4JUtils.generateLinkElement((String)"#", null, null, (String)"no-ajax-link", (String)StringUtils.capitalize((String)user));
        return DOM4JUtils.write((Element)link);
    }
}

