/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.tasks.portlet.service;

import java.util.List;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.tasks.portlet.model.Task;
import org.osivia.services.tasks.portlet.model.TaskActionType;
import org.osivia.services.tasks.portlet.model.Tasks;
import org.osivia.services.tasks.portlet.repository.TasksRepository;
import org.osivia.services.tasks.portlet.service.TasksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class TasksServiceImpl
implements TasksService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TasksRepository repository;

    public Tasks getTasks(PortalControllerContext portalControllerContext) throws PortletException {
        Tasks container = (Tasks)this.applicationContext.getBean(Tasks.class);
        List tasks = this.repository.getTasks(portalControllerContext);
        container.setTasks(tasks);
        return container;
    }

    public void acceptTask(PortalControllerContext portalControllerContext, Tasks tasks, int index) throws PortletException {
        this.updateTask(portalControllerContext, tasks, index, TaskActionType.ACCEPT);
    }

    public void rejectTask(PortalControllerContext portalControllerContext, Tasks tasks, int index) throws PortletException {
        this.updateTask(portalControllerContext, tasks, index, TaskActionType.REJECT);
    }

    public void closeTask(PortalControllerContext portalControllerContext, Tasks tasks, int index) throws PortletException {
        this.updateTask(portalControllerContext, tasks, index, TaskActionType.CLOSE);
    }

    private void updateTask(PortalControllerContext portalControllerContext, Tasks tasks, int index, TaskActionType actionType) throws PortletException {
        Task task = (Task)tasks.getTasks().get(index);
        this.repository.updateTask(portalControllerContext, tasks, task, actionType);
        List updatedTasks = this.repository.getTasks(portalControllerContext);
        tasks.setTasks(updatedTasks);
        if (portalControllerContext.getResponse() instanceof ActionResponse) {
            ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
            response.setRenderParameter("count", String.valueOf(updatedTasks.size()));
        }
    }
}

