/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.tasks.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.portlet.PortletException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.services.tasks.portlet.model.Task;
import org.osivia.services.tasks.portlet.model.TaskActionType;
import org.osivia.services.tasks.portlet.repository.GetTasksCommand;
import org.osivia.services.tasks.portlet.repository.TasksRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class TasksRepositoryImpl
implements TasksRepository {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IFormsService formsService;
    @Autowired
    private PersonService personService;

    public List<Task> getTasks(PortalControllerContext portalControllerContext) throws PortletException {
        ArrayList<Object> tasks;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Principal principal = portalControllerContext.getRequest().getUserPrincipal();
        if (principal == null) {
            tasks = new ArrayList<Task>(0);
        } else {
            String user = principal.getName();
            Set actors = this.getTaskActors(user);
            INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetTasksCommand.class, new Object[]{actors});
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
            tasks = new ArrayList(documents.size());
            for (Document document : documents) {
                if (!(document instanceof Document)) continue;
                String display = this.getTaskDisplay(portalControllerContext, document);
                PropertyMap taskVariables = document.getProperties().getMap("nt:task_variables");
                Person initiator = this.personService.getPerson(document.getString("nt:initiator"));
                Task task = (Task)this.applicationContext.getBean(Task.class);
                task.setDocument(document);
                task.setDisplay(display);
                task.setInitiator(initiator);
                task.setDate(document.getDate("dc:created"));
                task.setAcknowledgeable(BooleanUtils.isTrue((Boolean)taskVariables.getBoolean("acquitable")));
                task.setCloseable(BooleanUtils.isTrue((Boolean)taskVariables.getBoolean("closable")));
                tasks.add(task);
            }
        }
        return tasks;
    }

    private Set<String> getTaskActors(String user) {
        Person userP = this.personService.getPerson(user);
        List groups = userP.getProfiles();
        HashSet<String> actors = new HashSet<String>((groups.size() + 1) * 2);
        actors.add(user);
        actors.add("user:" + user);
        for (Name group : groups) {
            String cn = this.getCn(group);
            if (cn == null) continue;
            actors.add(cn);
            actors.add("group:" + cn);
        }
        return actors;
    }

    private String getCn(Name group) {
        Enumeration<String> str = group.getAll();
        while (group.getAll().hasMoreElements()) {
            String string = str.nextElement();
            if (!StringUtils.startsWith((String)string, (String)"cn=")) continue;
            return StringUtils.split((String)string, (char)'=')[1];
        }
        return null;
    }

    private String getTaskDisplay(PortalControllerContext portalControllerContext, Document task) throws PortletException {
        String transformedExpression;
        PropertyMap instanceProperties = task.getProperties().getMap("nt:pi");
        PropertyMap globalVariables = instanceProperties.getMap("pi:globalVariablesValues");
        PropertyMap taskVariables = task.getProperties().getMap("nt:task_variables");
        String expression = taskVariables.getString("stringMsg");
        HashMap variables = new HashMap(globalVariables.size() + taskVariables.size());
        for (Map.Entry entry : globalVariables.getMap().entrySet()) {
            variables.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        for (Map.Entry entry : taskVariables.getMap().entrySet()) {
            variables.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        variables.put("initiator", task.getString("nt:initiator"));
        variables.put("taskUuid", task.getId());
        variables.put("taskPath", task.getPath());
        try {
            transformedExpression = this.formsService.transform(portalControllerContext, expression, variables);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return transformedExpression;
    }

    public String getHelp(PortalControllerContext portalControllerContext) throws PortletException {
        String help;
        String location = System.getProperty("tasks.help.location");
        if (StringUtils.isBlank((String)location)) {
            help = null;
        } else {
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            String path = location.startsWith("/") ? location : NuxeoController.webIdToFetchPath((String)location);
            try {
                Document document = nuxeoController.fetchDocument(path);
                help = nuxeoController.transformHTMLContent(StringUtils.trimToEmpty((String)document.getString("note:note")));
            }
            catch (NuxeoException e) {
                if (e.getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    help = null;
                }
                throw e;
            }
        }
        return help;
    }

    public String updateTask(PortalControllerContext portalControllerContext, Task task, TaskActionType actionType) throws PortletException {
        String message;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Principal principal = portalControllerContext.getRequest().getUserPrincipal();
        String user = principal.getName();
        String actor = "user:" + user;
        String path = task.getDocument().getPath();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetTasksCommand.class, new Object[]{actor, path});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        Document document = documents.get(0);
        PropertyMap taskVariables = document.getProperties().getMap("nt:task_variables");
        String actionId = taskVariables.getString(actionType.getActionReference());
        try {
            Map updatedVariables = this.formsService.proceed(portalControllerContext, document, actionId, null);
            message = (String)updatedVariables.get("tasksNotificationMessage");
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        catch (FormFilterException e) {
            throw new PortletException((Throwable)e);
        }
        return message;
    }
}

