/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.tasks.portlet.service;

import java.util.List;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.tasks.ITasksService;
import org.osivia.services.tasks.portlet.model.Task;
import org.osivia.services.tasks.portlet.model.TaskActionType;
import org.osivia.services.tasks.portlet.model.Tasks;
import org.osivia.services.tasks.portlet.repository.TasksRepository;
import org.osivia.services.tasks.portlet.service.TasksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class TasksServiceImpl
implements TasksService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TasksRepository repository;
    @Autowired
    private ITasksService tasksService;

    public Tasks getTasks(PortalControllerContext portalControllerContext) throws PortletException {
        Tasks container = (Tasks)this.applicationContext.getBean(Tasks.class);
        List tasks = this.repository.getTasks(portalControllerContext);
        container.setTasks(tasks);
        container.setCount(tasks.size());
        String help = this.repository.getHelp(portalControllerContext);
        container.setHelp(help);
        return container;
    }

    public void acceptTask(PortalControllerContext portalControllerContext, Tasks tasks, int index) throws PortletException {
        this.updateTask(portalControllerContext, tasks, index, TaskActionType.ACCEPT);
    }

    public void rejectTask(PortalControllerContext portalControllerContext, Tasks tasks, int index) throws PortletException {
        this.updateTask(portalControllerContext, tasks, index, TaskActionType.REJECT);
    }

    public void closeTask(PortalControllerContext portalControllerContext, Tasks tasks, int index) throws PortletException {
        this.updateTask(portalControllerContext, tasks, index, TaskActionType.CLOSE);
    }

    private void updateTask(PortalControllerContext portalControllerContext, Tasks tasks, int index, TaskActionType actionType) throws PortletException {
        Task task = (Task)tasks.getTasks().get(index);
        String message = this.repository.updateTask(portalControllerContext, task, actionType);
        try {
            this.tasksService.resetTasksCount(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        if (StringUtils.isBlank((String)message)) {
            tasks.getTasks().remove(index);
        } else {
            task.setMessage(message);
        }
        tasks.setCount(tasks.getCount() - 1);
    }
}

