/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.fragment.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.Plugin;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.services.widgets.plugin.ew.CriteriaListEditableWindow;
import org.osivia.services.widgets.plugin.ew.LinksEditableWindow;
import org.osivia.services.widgets.plugin.ew.SetEditableWindow;
import org.osivia.services.widgets.plugin.ew.SliderListEditableWindow;
import org.osivia.services.widgets.plugin.ew.ZoomEditableWindow;
import org.osivia.services.widgets.plugin.fragment.LinksFragmentModule;
import org.osivia.services.widgets.plugin.fragment.SummaryFragmentModule;
import org.osivia.services.widgets.plugin.fragment.ZoomFragmentModule;
import org.osivia.services.widgets.plugin.list.PicturebookTemplateModule;
import org.osivia.services.widgets.plugin.list.SliderTemplateModule;
import org.osivia.services.widgets.plugin.player.AnnounceFolderPlayer;
import org.osivia.services.widgets.plugin.player.DocumentUrlContainerPlayer;
import org.osivia.services.widgets.plugin.player.PictureBookPlayer;
import org.osivia.services.widgets.plugin.theming.SearchTabGroup;

@Plugin(value="widgets.plugin")
public class WidgetsPlugin
extends AbstractPluginPortlet {
    public static final String STYLE_PICTUREBOOK = "picturebook";
    public static final String SCHEMAS_PICTUREBOOK = "dublincore, common, toutatice, note, files, acaren, webcontainer, file, picture";
    public static final String LIST_TEMPLATE_SLIDER = "slider";
    public static final String LIST_TEMPLATE_SLIDER_ANNONCE = "slider-annonce";
    public static final String LIST_TEMPLATE_SLIDER_PICTURE = "slider-picture";
    public static final String SLIDER_SCHEMAS = "dublincore, toutatice, picture, annonce";
    private static final String PLUGIN_NAME = "widgets.plugin";
    private IBundleFactory bundleFactory;

    public void init() throws PortletException {
        super.init();
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }

    protected void customizeCMSProperties(String customizationId, CustomizationContext context) {
        this.customizeDocumentTypes(context);
        this.customizePlayers(context);
        this.customizeListTemplates(context);
        this.customizeFragmentTypes(context);
        this.customizeEditableWindows(context);
        this.customizeTabGroups(context);
        this.customizeTaskbarItems(context);
    }

    private void customizeDocumentTypes(CustomizationContext context) {
        Map types = this.getDocTypes(context);
        DocumentType picture = new DocumentType("Picture", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-picture", false, true, true);
        types.put(picture.getName(), picture);
        this.addSubType(context, "PortalSite", picture.getName());
        this.addSubType(context, "PortalPage", picture.getName());
        this.addSubType(context, "Folder", picture.getName());
        this.addSubType(context, "OrderedFolder", picture.getName());
        DocumentType picturebook = new DocumentType("PictureBook", true, true, true, true, false, true, Arrays.asList(picture.getName(), "PictureBook"), null, "glyphicons glyphicons-pictures");
        types.put(picturebook.getName(), picturebook);
        this.addSubType(context, "Workspace", picturebook.getName());
        this.addSubType(context, "Room", picturebook.getName());
        DocumentType audio = new DocumentType("Audio", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-music", false, true, true);
        types.put(audio.getName(), audio);
        this.addSubType(context, "PortalSite", audio.getName());
        this.addSubType(context, "PortalPage", audio.getName());
        this.addSubType(context, "Folder", audio.getName());
        this.addSubType(context, "OrderedFolder", audio.getName());
        DocumentType video = new DocumentType("Video", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-film", false, true, true);
        types.put(video.getName(), video);
        this.addSubType(context, "PortalSite", video.getName());
        this.addSubType(context, "PortalPage", video.getName());
        this.addSubType(context, "Folder", video.getName());
        this.addSubType(context, "OrderedFolder", video.getName());
        DocumentType annonce = new DocumentType("Annonce", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-newspaper");
        types.put(annonce.getName(), annonce);
        this.addSubType(context, "Workspace", annonce.getName());
        this.addSubType(context, "Room", annonce.getName());
        this.addSubType(context, "PortalSite", annonce.getName());
        this.addSubType(context, "PortalPage", annonce.getName());
        DocumentType annonceFolder = new DocumentType("AnnonceFolder", true, true, false, false, false, true, Arrays.asList(annonce.getName()), null, "glyphicons glyphicons-newspaper");
        types.put(annonceFolder.getName(), annonceFolder);
        this.addSubType(context, "Workspace", annonceFolder.getName());
        this.addSubType(context, "Room", annonceFolder.getName());
        DocumentType urlContainer = new DocumentType("DocumentUrlContainer", true, true, true, true, false, true, Arrays.asList("DocumentUrlContainer", "ContextualLink"), null, "glyphicons glyphicons-bookmark");
        types.put("DocumentUrlContainer", urlContainer);
        this.addSubType(context, "Workspace", urlContainer.getName());
        this.addSubType(context, "Room", urlContainer.getName());
    }

    private void customizePlayers(CustomizationContext context) {
        PortletContext portletContext = this.getPortletContext();
        List players = this.getPlayers(context);
        PictureBookPlayer picturebook = new PictureBookPlayer(portletContext);
        players.add(0, picturebook);
        AnnounceFolderPlayer annonceFolder = new AnnounceFolderPlayer(portletContext);
        players.add(annonceFolder);
        DocumentUrlContainerPlayer urlContainer = new DocumentUrlContainerPlayer(portletContext);
        players.add(urlContainer);
    }

    private void customizeListTemplates(CustomizationContext context) {
        PortletContext portletContext = this.getPortletContext();
        Bundle bundle = this.bundleFactory.getBundle(context.getLocale());
        Map templates = this.getListTemplates(context);
        ListTemplate picturebook = new ListTemplate(STYLE_PICTUREBOOK, bundle.getString("LIST_TEMPLATE_PICTUREBOOK"), SCHEMAS_PICTUREBOOK);
        picturebook.setModule((IPortletModule)new PicturebookTemplateModule(portletContext));
        templates.put(picturebook.getKey(), picturebook);
        ListTemplate slider = new ListTemplate(LIST_TEMPLATE_SLIDER, bundle.getString("LIST_TEMPLATE_SLIDER"), SLIDER_SCHEMAS);
        slider.setModule((IPortletModule)new SliderTemplateModule(portletContext));
        templates.put(slider.getKey(), slider);
        ListTemplate sliderAnnonces = new ListTemplate(LIST_TEMPLATE_SLIDER_ANNONCE, bundle.getString("LIST_TEMPLATE_SLIDER_ANNONCE"), SLIDER_SCHEMAS);
        sliderAnnonces.setModule((IPortletModule)new SliderTemplateModule(portletContext));
        templates.put(sliderAnnonces.getKey(), sliderAnnonces);
        ListTemplate sliderPictures = new ListTemplate(LIST_TEMPLATE_SLIDER_PICTURE, bundle.getString("LIST_TEMPLATE_SLIDER_PICTURE"), SLIDER_SCHEMAS);
        sliderPictures.setModule((IPortletModule)new SliderTemplateModule(portletContext));
        templates.put(sliderPictures.getKey(), sliderPictures);
    }

    private void customizeFragmentTypes(CustomizationContext context) {
        PortletContext portletContext = this.getPortletContext();
        Bundle bundle = this.bundleFactory.getBundle(context.getLocale());
        List types = this.getFragmentTypes(context);
        FragmentType zoom = new FragmentType("zoom_property", bundle.getString("FRAGMENT_TYPE_ZOOM"), (IFragmentModule)new ZoomFragmentModule(portletContext));
        types.add(zoom);
        FragmentType links = new FragmentType("links_property", bundle.getString("FRAGMENT_TYPE_LINKS"), (IFragmentModule)new LinksFragmentModule(portletContext));
        types.add(links);
        FragmentType summary = new FragmentType("fgts_summary", bundle.getString("FRAGMENT_TYPE_SUMMARY"), (IFragmentModule)new SummaryFragmentModule(portletContext));
        types.add(summary);
    }

    private void customizeEditableWindows(CustomizationContext context) {
        Map editableWindows = this.getEditableWindows(context);
        SliderListEditableWindow slider = new SliderListEditableWindow("toutatice-portail-cms-nuxeo-viewListPortletInstance", "slider_liste_Frag_");
        editableWindows.put("fgt.slider_list", slider);
        SetEditableWindow set = new SetEditableWindow("toutatice-portail-cms-nuxeo-viewListPortletInstance", "set_Frag_");
        editableWindows.put("fgt.set", set);
        CriteriaListEditableWindow criteriaList = new CriteriaListEditableWindow("toutatice-portail-cms-nuxeo-viewListPortletInstance", "criteria_liste_Frag_");
        editableWindows.put("fgt.criteria_list", criteriaList);
        ZoomEditableWindow zoom = new ZoomEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "zoom_frag_");
        editableWindows.put("fgt.zoom", zoom);
        LinksEditableWindow links = new LinksEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "links_frag_");
        editableWindows.put("fgt.links", links);
    }

    private void customizeTabGroups(CustomizationContext context) {
        Map tabGroups = this.getTabGroups(context);
        SearchTabGroup search = new SearchTabGroup();
        tabGroups.put(search.getName(), search);
    }

    private void customizeTaskbarItems(CustomizationContext context) {
        TaskbarItems items = this.getTaskbarItems(context);
        TaskbarFactory factory = this.getTaskbarService().getFactory();
        TaskbarItem gallery = factory.createCmsTaskbarItem("GALLERY", "GALLERY_TASK", "glyphicons glyphicons-pictures", "PictureBook");
        gallery.setToDefault(2);
        items.add(gallery);
        TaskbarItem news = factory.createCmsTaskbarItem("NEWS", "NEWS_TASK", "glyphicons glyphicons-newspaper", "AnnonceFolder");
        items.add(news);
        TaskbarItem bookmarks = factory.createCmsTaskbarItem("BOOKMARKS", "BOOKMARKS_TASK", "glyphicons glyphicons-bookmark", "DocumentUrlContainer");
        items.add(bookmarks);
    }
}

