/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.issued.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import java.util.Date;
import javax.portlet.PortletException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.widgets.issued.portlet.repository.IssuedRepository;
import org.osivia.services.widgets.issued.portlet.repository.command.UpdateIssuedCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class IssuedRepositoryImpl
implements IssuedRepository {
    @Autowired
    private ApplicationContext applicationContext;

    public Date getIssuedDate(PortalControllerContext portalControllerContext, String path) throws PortletException {
        NuxeoDocumentContext documentContext = this.getDocumentContext(portalControllerContext, path);
        documentContext.reload();
        Document document = documentContext.getDocument();
        Date date = document.getDate("ttc:publicationDate");
        if (date == null) {
            date = document.getDate("dc:issued");
        }
        return date;
    }

    public boolean setIssuedDate(PortalControllerContext portalControllerContext, String path, Date date) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = this.getDocumentContext(portalControllerContext, path);
        NuxeoPublicationInfos publicationInfos = documentContext.getPublicationInfos();
        Document document = documentContext.getDocument();
        boolean publish = publicationInfos.isPublished() && !publicationInfos.isBeingModified();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(UpdateIssuedCommand.class, new Object[]{document, date, publish});
        nuxeoController.executeNuxeoCommand(command);
        return publish;
    }

    private NuxeoDocumentContext getDocumentContext(PortalControllerContext portalControllerContext, String path) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setDisplayLiveVersion("1");
        return nuxeoController.getDocumentContext(path);
    }
}

