/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin.ew;

import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindowHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.widgets.plugin.ew.CriteriaListEditableWindow;

public class SliderListEditableWindow
extends CriteriaListEditableWindow {
    public static final String SLIDER_LIST_SCHEMA = "sldlistfgt:sliderListFragment";
    public static final String ALL_DOC_TYPES = "others";

    public SliderListEditableWindow(String instancePortlet, String prefixWindow) {
        super(instancePortlet, prefixWindow);
    }

    protected Object getDocTypes(PropertyMap requestCriteria) {
        return requestCriteria.get("docType");
    }

    protected String getDocTypesCriterion(StringBuffer docTypesCriterion, Object docTypes) {
        String docType;
        if (docTypes != null && docTypes instanceof String && !ALL_DOC_TYPES.equalsIgnoreCase(docType = (String)docTypes)) {
            docTypesCriterion.append(" ecm:primaryType = '").append(docType).append("'");
        }
        return docTypesCriterion.toString();
    }

    protected PropertyMap getListSchema(Document doc, PropertyMap fragment) {
        return EditableWindowHelper.findSchemaByRefURI((Document)doc, (String)SLIDER_LIST_SCHEMA, (String)fragment.getString("uri"));
    }

    protected Map<String, String> fillDisplayProperties(PropertyMap schema, Map<String, String> properties) {
        PropertyMap displayCriteria = (PropertyMap)schema.get("displaySlider");
        properties.put("osivia.cms.maxItems", (String)displayCriteria.get("nbItems"));
        properties.put("timer", (String)displayCriteria.get("timer"));
        PropertyMap requestCriteria = (PropertyMap)schema.get("requestCriteria");
        StringBuilder style = new StringBuilder();
        style.append("slider");
        String docType = requestCriteria.getString("docType");
        if (!ALL_DOC_TYPES.equals(docType)) {
            style.append("-");
            style.append(StringUtils.lowerCase((String)docType));
        }
        properties.put("osivia.cms.style", style.toString());
        return properties;
    }

    public List<String> prepareDelete(Document doc, String refURI) {
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        this.prepareDeleteGeneric(propertiesToRemove, doc, refURI);
        Integer indexToRemove = EditableWindowHelper.findIndexByRefURI((Document)doc, (String)SLIDER_LIST_SCHEMA, (String)refURI);
        propertiesToRemove.add(SLIDER_LIST_SCHEMA.concat("/").concat(indexToRemove.toString()));
        return propertiesToRemove;
    }
}

