/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.issued.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PathRef;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UpdateIssuedCommand
implements INuxeoCommand {
    private static final String ID = "Document.TTCPPublish";
    private final Document document;
    private final Date date;
    private final boolean publish;

    public UpdateIssuedCommand(Document document, Date date, boolean publish) {
        this.document = document;
        this.date = date;
        this.publish = publish;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        this.updateIssuedDate(nuxeoSession);
        if (this.publish) {
            this.publish(nuxeoSession);
        }
        return null;
    }

    private void updateIssuedDate(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        PropertyMap properties = new PropertyMap(1);
        properties.set("ttc:publicationDate", this.date);
        documentService.update((DocRef)this.document, properties);
    }

    private void publish(Session nuxeoSession) throws Exception {
        String parentPath = StringUtils.substringBeforeLast((String)this.document.getPath(), (String)"/");
        PathRef parent = new PathRef(parentPath);
        OperationRequest request = nuxeoSession.newRequest(ID);
        request.setInput((OperationInput)this.document);
        request.set("target", (Object)parent);
        request.execute();
    }

    public String getId() {
        return null;
    }
}

