/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.widgets.plugin.ew;

import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindowHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class SetEditableWindow
extends EditableWindow {
    public static final String SET_SCHEMA = "setfgt:setFragment";

    public SetEditableWindow(String instancePortlet, String prefixWindow) {
        super(instancePortlet, prefixWindow);
    }

    public Map<String, String> fillProps(Document doc, PropertyMap fragment, Boolean modeEditionPage) {
        Map properties = super.fillGenericProps(doc, fragment, modeEditionPage);
        PropertyMap mapListe = EditableWindowHelper.findSchemaByRefURI((Document)doc, (String)SET_SCHEMA, (String)fragment.getString("uri"));
        PropertyList setItems = mapListe.getList("setItems");
        if (setItems != null && !setItems.isEmpty()) {
            properties.put("osivia.cms.ordering", "true");
            properties.put("osivia.cms.ordering.size", String.valueOf(setItems.size()));
            ArrayList<String> webIds = new ArrayList<String>(setItems.size());
            for (int i = 0; i < setItems.list().size(); ++i) {
                PropertyMap setItemMap = setItems.getMap(i);
                String webid = setItemMap.getString("setWebId");
                properties.put("osivia.cms.ordering." + i, webid);
                webIds.add("'" + webid + "'");
            }
            String request = this.buildRequest(webIds);
            properties.put("osivia.nuxeoRequest", request);
        } else {
            properties.put("osivia.nuxeoRequest", "EMPTY_REQUEST");
        }
        properties.put("osivia.cms.displayLiveVersion", "__inherited");
        properties.put("osivia.cms.style", mapListe.getString("style"));
        properties.put("osivia.beanShell", String.valueOf(false));
        properties.put("osivia.cms.scope", null);
        properties.put("osivia.cms.hideMetaDatas", "1");
        properties.put("osivia.displayNuxeoRequest", String.valueOf(false));
        properties.put("osivia.cms.requestFilteringPolicy", null);
        properties.put("osivia.permaLinkRef", null);
        properties.put("osivia.rssLinkRef", null);
        properties.put("osivia.rssTitle", null);
        properties.put("osivia.cms.uri", doc.getPath());
        return properties;
    }

    private String buildRequest(List<String> webIds) {
        String webIdJoined = StringUtils.join(webIds, (String)",");
        return "ttc:webid IN (" + webIdJoined + ")";
    }

    public List<String> prepareDelete(Document doc, String refURI) {
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        this.prepareDeleteGeneric(propertiesToRemove, doc, refURI);
        Integer findIndexByRefURI = EditableWindowHelper.findIndexByRefURI((Document)doc, (String)SET_SCHEMA, (String)refURI);
        propertiesToRemove.add(SET_SCHEMA.concat("/").concat(findIndexByRefURI.toString()));
        Collections.reverse(propertiesToRemove);
        return propertiesToRemove;
    }
}

